/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.mehvahdjukaar.moonlight.api.client.util.TextUtil;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.api.IAntiqueTextProvider;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTextures;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2625;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5699;
import net.minecraft.class_5837;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class TextHolder
implements IAntiqueTextProvider {
    private static final Int2ObjectArrayMap<Codec<class_2561[]>> CODEC_CACHE = new Int2ObjectArrayMap();
    private final int lines;
    private final int maxWidth;
    private final class_2561[] messages;
    private final class_2561[] filteredMessages;
    private final class_5481[] renderMessages;
    private class_1767 color = class_1767.field_7963;
    private boolean renderMessagedFiltered;
    private boolean hasGlowingText = false;
    private boolean hasAntiqueInk = false;

    private static Codec<class_2561[]> compCodec(int size) {
        return (Codec)CODEC_CACHE.computeIfAbsent(size, s -> class_5699.field_43173.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)s).map(l -> (class_2561[])l.toArray(class_2561[]::new)), components -> Arrays.stream(components).toList()));
    }

    public TextHolder(int size, int maxWidth) {
        this.lines = size;
        this.maxWidth = maxWidth;
        this.renderMessages = new class_5481[size];
        this.messages = new class_2561[size];
        this.filteredMessages = new class_2561[size];
        Arrays.fill(this.messages, class_5244.field_39003);
        Arrays.fill(this.filteredMessages, class_5244.field_39003);
    }

    public int getMaxLineCharacters() {
        return (int)((float)this.getMaxLineVisualWidth() / 6.0f);
    }

    public int getMaxLineVisualWidth() {
        return this.maxWidth;
    }

    public void load(class_2487 compound, class_1937 level, class_2338 pos) {
        if (compound.method_10545("TextHolder")) {
            class_2487 com = compound.method_10562("TextHolder");
            this.color = class_1767.method_7793((String)com.method_10558("color"), (class_1767)class_1767.field_7963);
            this.hasGlowingText = com.method_10577("has_glowing_text");
            this.hasAntiqueInk = com.method_10577("has_antique_ink");
            if (this.lines != 0) {
                class_2561[] v = this.decodeMessage(com.method_10580("message"), level, pos);
                System.arraycopy(v, 0, this.messages, 0, v.length);
                class_2520 filtered = com.method_10580("filtered_message");
                if (filtered != null) {
                    v = this.decodeMessage(filtered, level, pos);
                    System.arraycopy(v, 0, this.filteredMessages, 0, v.length);
                } else {
                    System.arraycopy(this.messages, 0, this.filteredMessages, 0, this.messages.length);
                }
                for (int j = 0; j < this.renderMessages.length; ++j) {
                    this.renderMessages[j] = null;
                }
            }
        }
    }

    private class_2561[] decodeMessage(class_2520 com, class_1937 level, class_2338 pos) {
        return (class_2561[])Arrays.stream((class_2561[])((Pair)TextHolder.compCodec(this.lines).decode((DynamicOps)class_2509.field_11560, (Object)com).getOrThrow(false, s -> {})).getFirst()).map(c -> {
            if (level instanceof class_3218) {
                class_3218 sl = (class_3218)level;
                try {
                    return class_2564.method_10881((class_2168)class_2625.method_50006(null, (class_1937)sl, (class_2338)pos), (class_2561)c, null, (int)0);
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
            return c;
        }).toArray(class_2561[]::new);
    }

    public class_2487 save(class_2487 compound) {
        class_2487 com = new class_2487();
        com.method_10582("color", this.color.method_7792());
        com.method_10556("has_glowing_text", this.hasGlowingText);
        com.method_10556("has_antique_ink", this.hasAntiqueInk);
        if (this.lines != 0) {
            com.method_10566("message", (class_2520)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)class_2509.field_11560, (Object)this.messages).getOrThrow(false, s -> {}));
            if (this.hasFilteredMessage()) {
                com.method_10566("filtered_message", (class_2520)TextHolder.compCodec(this.lines).encodeStart((DynamicOps)class_2509.field_11560, (Object)this.filteredMessages).getOrThrow(false, s -> {}));
            }
        }
        compound.method_10566("TextHolder", (class_2520)com);
        return compound;
    }

    private boolean hasFilteredMessage() {
        for (int i = 0; i < this.filteredMessages.length; ++i) {
            class_2561 component = this.filteredMessages[i];
            if (component.equals(this.messages[i])) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.lines;
    }

    public class_2561 getMessage(int line, boolean filtered) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        return this.getMessages(filtered)[line];
    }

    public class_2561[] getMessages(boolean filtered) {
        return filtered ? this.filteredMessages : this.messages;
    }

    public void setMessage(int i, class_2561 component) {
        this.setMessage(i, component, component);
    }

    public void setMessage(int i, class_2561 message, class_2561 filtered) {
        if (this.hasAntiqueInk) {
            class_5250 t = message.method_27661();
            message = t.method_10862(message.method_10866().method_27704(ModTextures.ANTIQUABLE_FONT));
            t = filtered.method_27661();
            filtered = t.method_10862(filtered.method_10866().method_27704(ModTextures.ANTIQUABLE_FONT));
        }
        this.messages[i] = message;
        this.filteredMessages[i] = filtered;
        this.renderMessages[i] = null;
    }

    public class_1767 getColor() {
        return this.color;
    }

    public boolean setColor(class_1767 newColor) {
        if (newColor != this.color) {
            this.color = newColor;
            return true;
        }
        return false;
    }

    public boolean hasGlowingText() {
        return this.hasGlowingText;
    }

    public void setHasGlowingText(boolean glowing) {
        this.hasGlowingText = glowing;
    }

    public class_1269 playerInteract(class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        boolean success = false;
        boolean commandSuccess = this.executeClickCommandsIfPresent(player, level, pos);
        if (item == class_1802.field_8794) {
            if (this.hasGlowingText || this.hasAntiqueInk) {
                level.method_8396(null, pos, class_3417.field_28397, class_3419.field_15245, 1.0f, 1.0f);
                this.setAntiqueInk(false);
                this.hasGlowingText = false;
                success = true;
            }
        } else if (item == ModRegistry.ANTIQUE_INK.get()) {
            if (!this.hasAntiqueInk) {
                level.method_8396(null, pos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                this.setAntiqueInk(true);
                success = true;
            }
        } else if (item == class_1802.field_28410) {
            if (!this.hasGlowingText) {
                level.method_8396(null, pos, class_3417.field_28392, class_3419.field_15245, 1.0f, 1.0f);
                this.hasGlowingText = true;
                success = true;
            }
        } else {
            class_1767 dyeColor = ForgeHelper.getColor((class_1799)stack);
            if (dyeColor != null && this.setColor(dyeColor)) {
                level.method_8396(null, pos, class_3417.field_28391, class_3419.field_15245, 1.0f, 1.0f);
                success = true;
            }
        }
        if (success) {
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        if (commandSuccess) {
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean hasEditableText(boolean filtering) {
        return Arrays.stream(this.getMessages(filtering)).allMatch(component -> component.equals(class_5244.field_39003) || component.method_10851() instanceof class_2585);
    }

    public boolean executeClickCommandsIfPresent(class_1657 player, class_1937 level, class_2338 pos) {
        class_2561[] messages;
        boolean success = false;
        for (class_2561 component : messages = this.getMessages(player.method_33793())) {
            class_2583 style = component.method_10866();
            class_2558 clickEvent = style.method_10970();
            if (clickEvent == null || clickEvent.method_10845() != class_2558.class_2559.field_11750) continue;
            player.method_5682().method_3734().method_44252(class_2625.method_50006((class_1657)player, (class_1937)level, (class_2338)pos), clickEvent.method_10844());
            success = true;
        }
        return success;
    }

    @Override
    public boolean hasAntiqueInk() {
        return this.hasAntiqueInk;
    }

    @Override
    public void setAntiqueInk(boolean hasInk) {
        this.hasAntiqueInk = hasInk;
        for (int i = 0; i < this.messages.length; ++i) {
            this.setMessage(i, this.messages[i], this.filteredMessages[i]);
        }
    }

    public void clearEffects() {
        this.setColor(class_1767.field_7963);
        this.setAntiqueInk(false);
        this.setHasGlowingText(false);
    }

    public boolean isEmpty(@Nullable class_1657 player) {
        boolean b = player == null || player.method_33793();
        return !Arrays.stream(this.getMessages(b)).anyMatch(component -> !component.getString().isEmpty());
    }

    public void clear() {
        Arrays.fill(this.filteredMessages, class_5244.field_39003);
        Arrays.fill(this.messages, class_5244.field_39003);
        this.clearEffects();
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_5481 getRenderMessages(int line, class_327 font) {
        if (line >= this.lines) {
            throw new IndexOutOfBoundsException("Tried to access lie " + line + " of Text Holder of size " + this.lines);
        }
        boolean filtered = class_310.method_1551().method_33883();
        if (this.renderMessages[line] == null || this.renderMessagedFiltered != filtered) {
            List list = font.method_1728((class_5348)this.getMessage(line, filtered), this.getMaxLineVisualWidth());
            this.renderMessages[line] = list.isEmpty() ? class_5481.field_26385 : (class_5481)list.get(0);
        }
        return this.renderMessages[line];
    }

    @Environment(value=EnvType.CLIENT)
    public TextUtil.RenderProperties computeRenderProperties(int combinedLight, Vector3f normal, BooleanSupplier shouldShowGlow) {
        return TextUtil.renderProperties((class_1767)this.getColor(), (boolean)this.hasGlowingText(), (float)ClientConfigs.getSignColorMult(), (int)combinedLight, (class_2583)(this.hasAntiqueInk() ? class_2583.field_24360.method_27704(ModTextures.ANTIQUABLE_FONT) : class_2583.field_24360), (Vector3f)normal, (BooleanSupplier)shouldShowGlow);
    }

    @Environment(value=EnvType.CLIENT)
    public TextUtil.RenderProperties getGUIRenderTextProperties() {
        return this.computeRenderProperties(0xF000F0, class_2350.field_11036.method_23955(), () -> true);
    }

    public void acceptClientMessages(class_1657 player, List<class_5837> list) {
        for (int i = 0; i < list.size(); ++i) {
            class_5837 filteredText = list.get(i);
            class_2583 style = this.getMessage(i, player.method_33793()).method_10866();
            if (player.method_33793()) {
                this.setMessage(i, (class_2561)class_2561.method_43470((String)filteredText.method_45061()).method_10862(style));
                continue;
            }
            this.setMessage(i, (class_2561)class_2561.method_43470((String)filteredText.comp_841()).method_10862(style), (class_2561)class_2561.method_43470((String)filteredText.method_45061()).method_10862(style));
        }
    }
}

