/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_918;

public class HourglassTimeData {
    public static final HourglassTimeData EMPTY = new HourglassTimeData((class_6885<class_1792>)class_6885.method_40246((class_6880[])new class_6880[0]), 0, 0, Optional.empty(), 99);
    public static final Codec<HourglassTimeData> REGISTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_6895.method_40340((class_5321)class_7924.field_41197).fieldOf("items").forGetter(p -> p.dusts), (App)class_5699.field_33442.fieldOf("duration").forGetter(p -> p.duration), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.light), (App)class_2960.field_25139.optionalFieldOf("texture").forGetter(p -> p.texture), (App)class_5699.field_33442.optionalFieldOf("ordering", (Object)0).forGetter(p -> p.ordering)).apply((Applicative)instance, HourglassTimeData::new));
    public static final Codec<HourglassTimeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.listOf().fieldOf("items").forGetter(p -> p.dusts.method_40239().map(h -> ((class_5321)h.method_40230().get()).method_29177()).toList()), (App)class_5699.field_33442.fieldOf("duration").forGetter(p -> p.duration), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.light), (App)class_2960.field_25139.optionalFieldOf("texture").forGetter(p -> p.texture), (App)class_5699.field_33442.optionalFieldOf("ordering", (Object)0).forGetter(p -> p.ordering)).apply((Applicative)instance, HourglassTimeData::createSafe));
    private final class_6885<class_1792> dusts;
    private final int duration;
    private final int light;
    private final Optional<class_2960> texture;
    private final int ordering;

    private static HourglassTimeData createSafe(List<class_2960> dusts, int dur, int light, Optional<class_2960> texture, int order) {
        ArrayList holders = new ArrayList();
        dusts.forEach(r -> class_7923.field_41178.method_40264(class_5321.method_29179((class_5321)class_7924.field_41197, (class_2960)r)).ifPresent(holders::add));
        return new HourglassTimeData((class_6885<class_1792>)class_6885.method_40242(holders), dur, light, texture, order);
    }

    public HourglassTimeData(class_6885<class_1792> owner, int duration, int light, Optional<class_2960> texture, int priority) {
        this.dusts = owner;
        this.duration = duration;
        this.light = light;
        this.texture = texture;
        this.ordering = priority;
    }

    public class_2960 computeTexture(class_1799 i, class_1937 world) {
        class_310 mc = class_310.method_1551();
        if (this.texture.isEmpty()) {
            class_918 itemRenderer = mc.method_1480();
            class_1087 model = itemRenderer.method_4019(i, world, null, 0);
            return model.method_4711().method_45851().method_45816();
        }
        return this.texture.get();
    }

    public Stream<class_6880<class_1792>> getItems() {
        return this.dusts.method_40239();
    }

    public int getLight() {
        return this.light;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public float getIncrement() {
        return 1.0f / (float)this.duration;
    }
}

