/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.block.IOwnerProtected;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.supplementaries.client.screens.SignPostScreen;
import net.mehvahdjukaar.supplementaries.common.block.ITextHolderProvider;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.TextHolder;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.mehvahdjukaar.supplementaries.common.items.SignPostItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FramedBlocksCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1759;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class SignPostBlockTile
extends MimicBlockTile
implements ITextHolderProvider,
IOwnerProtected {
    public static final ModelDataKey<Boolean> FRAMED_KEY = ModBlockProperties.FRAMED;
    private final Sign signUp = new Sign(false, true, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private final Sign signDown = new Sign(false, false, 0.0f, WoodTypeRegistry.OAK_TYPE);
    private boolean isWaxed = false;
    private UUID owner = null;
    private boolean isSlim = false;
    private boolean framed = false;
    @Nullable
    private UUID playerWhoMayEdit;

    public SignPostBlockTile(class_2338 pos, class_2680 state) {
        super(ModRegistry.SIGN_POST_TILE.get(), pos, state);
    }

    public ExtraModelData getExtraModelData() {
        return ExtraModelData.builder().with(FRAMED_KEY, (Object)this.framed).with(MIMIC_KEY, (Object)this.getHeldBlock()).build();
    }

    @Override
    public TextHolder getTextHolder(int i) {
        return this.getSign((boolean)(i == 0 ? true : false)).text;
    }

    @Override
    public int textHoldersCount() {
        return 2;
    }

    public float getPointingYaw(boolean up) {
        if (up) {
            return this.signUp.getPointing();
        }
        return this.signDown.getPointing();
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.framed = compound.method_10577("Framed");
        this.signUp.load(compound.method_10562("SignUp"), this.field_11863, this.field_11867);
        this.signDown.load(compound.method_10562("SignDown"), this.field_11863, this.field_11867);
        this.loadOwner(compound);
        this.isSlim = this.mimic.method_26204() instanceof StickBlock;
        if (compound.method_10545("Waxed")) {
            this.isWaxed = compound.method_10577("Waxed");
        }
    }

    public void method_11007(class_2487 compound) {
        super.method_11007(compound);
        compound.method_10556("Framed", this.framed);
        compound.method_10566("SignUp", (class_2520)this.signUp.save());
        compound.method_10566("SignDown", (class_2520)this.signDown.save());
        this.saveOwner(compound);
        if (this.isWaxed) {
            compound.method_10556("Waxed", this.isWaxed);
        }
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    public boolean rotateSign(boolean up, float angle, boolean constrainAngle) {
        if (up && this.signUp.active) {
            this.signUp.rotateBy(angle, constrainAngle);
            return true;
        }
        if (this.signDown.active) {
            this.signDown.rotateBy(angle, constrainAngle);
            return true;
        }
        return false;
    }

    public void openScreen(class_1937 level, class_2338 pos, class_1657 player) {
        SignPostScreen.open(this);
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public Sign getSignUp() {
        return this.signUp;
    }

    public Sign getSignDown() {
        return this.signDown;
    }

    public Sign getSign(boolean up) {
        return up ? this.getSignUp() : this.getSignDown();
    }

    public boolean isFramed() {
        return this.framed;
    }

    public boolean initializeSignAfterConversion(WoodType woodType, int r, boolean up, boolean slim, boolean framed) {
        Sign sign = this.getSign(up);
        if (!sign.active) {
            sign.active = true;
            sign.woodType = woodType;
            sign.yaw = 90.0f + (float)r * -22.5f;
            this.framed = framed;
            this.isSlim = slim;
            return true;
        }
        return false;
    }

    public class_1269 handleInteraction(class_2680 state, class_3218 level, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit, class_1799 itemstack) {
        class_1792 item = itemstack.method_7909();
        boolean emptyHand = itemstack.method_7960();
        boolean isSneaking = player.method_5715() && emptyHand;
        boolean ind = this.getClickedSignIndex(hit.method_17784());
        if (hit.method_17780().method_10166() != class_2350.class_2351.field_11052) {
            boolean success;
            Sign sign = this.getSign(ind);
            if (!sign.active && item instanceof SignPostItem) {
                return class_1269.field_5811;
            }
            if (isSneaking) {
                sign.toggleDirection();
                this.method_5431();
                level.method_8413(pos, state, state, 3);
                level.method_8396(null, pos, class_3417.field_15038, class_3419.field_15245, 1.0f, 0.6f);
                return class_1269.field_21466;
            }
            if (item instanceof class_1759) {
                class_2338 pointingPos;
                class_2338 class_23382 = pointingPos = class_1759.method_26365((class_1799)itemstack) ? this.getLodestonePos((class_1937)level, itemstack) : this.getWorldSpawnPos((class_1937)level);
                if (pointingPos != null) {
                    if (sign.active) {
                        sign.pointToward(pos, pointingPos);
                    }
                    this.method_5431();
                    level.method_8413(pos, state, state, 3);
                    return class_1269.field_21466;
                }
                return class_1269.field_5814;
            }
            if (CompatHandler.FRAMEDBLOCKS && this.framed && (success = FramedBlocksCompat.interactWithFramedSignPost(this, player, handIn, itemstack, (class_1937)level, pos))) {
                return class_1269.field_21466;
            }
        }
        return this.interactWithTextHolder(ind ? 0 : 1, (class_1937)level, pos, state, player, handIn);
    }

    public boolean getClickedSignIndex(class_243 hit) {
        double y = hit.field_1351;
        y = y < 0.0 ? (y += (double)(1 - (int)y)) : (y -= (double)((int)y));
        return y > 0.5;
    }

    public Sign getClickedSign(class_243 hit) {
        return this.getSign(this.getClickedSignIndex(hit));
    }

    @Nullable
    private class_2338 getLodestonePos(class_1937 world, class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag != null) {
            Optional optional;
            boolean flag = tag.method_10545("LodestonePos");
            boolean flag1 = tag.method_10545("LodestoneDimension");
            if (flag && flag1 && (optional = class_1937.field_25178.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("LodestoneDimension")).result()).isPresent() && world.method_27983() == optional.get()) {
                return class_2512.method_10691((class_2487)tag.method_10562("LodestonePos"));
            }
        }
        return null;
    }

    @Nullable
    private class_2338 getWorldSpawnPos(class_1937 world) {
        return world.method_8597().comp_645() ? new class_2338(world.method_8401().method_215(), world.method_8401().method_144(), world.method_8401().method_166()) : null;
    }

    @Override
    public void setWaxed(boolean waxed) {
        this.isWaxed = waxed;
    }

    @Override
    public boolean isWaxed() {
        return this.isWaxed;
    }

    @Override
    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    @Override
    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public static final class Sign {
        public final TextHolder text;
        private boolean active;
        private boolean left;
        private float yaw;
        private WoodType woodType;

        private Sign(boolean active, boolean left, float yaw, WoodType woodType) {
            this.active = active;
            this.left = left;
            this.yaw = yaw;
            this.woodType = woodType;
            this.text = new TextHolder(1, 90);
        }

        public void load(class_2487 compound, class_1937 level, class_2338 pos) {
            this.active = compound.method_10577("Active");
            this.left = compound.method_10577("Left");
            this.yaw = compound.method_10583("Yaw");
            this.woodType = WoodTypeRegistry.fromNBT((String)compound.method_10558("WoodType"));
            this.text.load(compound, level, pos);
        }

        public class_2487 save() {
            class_2487 compound = new class_2487();
            compound.method_10548("Yaw", this.yaw);
            compound.method_10556("Left", this.left);
            compound.method_10556("Active", this.active);
            compound.method_10582("WoodType", this.woodType.toString());
            this.text.save(compound);
            return compound;
        }

        public void pointToward(class_2338 myPos, class_2338 targetPos) {
            float yaw = (float)(Math.atan2((double)targetPos.method_10263() - (double)myPos.method_10263(), (double)targetPos.method_10260() - (double)myPos.method_10260()) * 57.2957763671875);
            this.setYaw(yaw);
        }

        private float getPointing() {
            return class_3532.method_15393((float)(-this.yaw - (float)(this.left ? 180 : 0)));
        }

        private void setYaw(float yaw) {
            this.yaw = class_3532.method_15393((float)(yaw - (float)(this.left ? 180 : 0)));
        }

        private void rotateBy(float angle, boolean constrainAngle) {
            this.yaw = class_3532.method_15393((float)(this.yaw + angle));
            if (constrainAngle) {
                this.yaw -= this.yaw % 22.5f;
            }
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setLeft(boolean left) {
            this.left = left;
        }

        public void setWoodType(WoodType woodType) {
            this.woodType = woodType;
        }

        public boolean active() {
            return this.active;
        }

        public boolean left() {
            return this.left;
        }

        public float yaw() {
            return this.yaw;
        }

        public WoodType woodType() {
            return this.woodType;
        }

        public void toggleDirection() {
            this.left = !this.left;
        }

        public class_1799 getItem() {
            return new class_1799((class_1935)ModRegistry.SIGN_POST_ITEMS.get(this.woodType));
        }
    }
}

