/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.misc.songs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.items.InstrumentItem;
import net.mehvahdjukaar.supplementaries.common.misc.songs.Song;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundPlaySongNotesPacket;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncSongsPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2428;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import org.jetbrains.annotations.NotNull;

public class SongsManager
extends class_4309 {
    private static final Map<String, Song> SONGS = new LinkedHashMap<String, Song>();
    private static final List<class_6008.class_6010<String>> SONG_WEIGHTED_LIST = new ArrayList<class_6008.class_6010<String>>();
    private static final Map<UUID, Song> CURRENTLY_PAYING = new HashMap<UUID, Song>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final SongsManager RELOAD_INSTANCE = new SongsManager();
    private static final Map<Long, List<Integer>> RECORDING = new HashMap<Long, List<Integer>>();
    private static final List<class_2766> WHITELIST = new ArrayList<class_2766>();
    private static boolean isRecording = false;

    public SongsManager() {
        super(GSON, "flute_songs");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 manager, class_3695 profile) {
        SONGS.clear();
        SONG_WEIGHTED_LIST.clear();
        ArrayList temp = new ArrayList();
        jsons.forEach((key, json) -> {
            try {
                DataResult result = Song.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json);
                Song song = (Song)result.getOrThrow(false, e -> Supplementaries.LOGGER.error("Failed to parse flute song: {}", e));
                temp.add(song);
                SongsManager.addSong(song);
            }
            catch (Exception e2) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for song " + key);
            }
        });
        if (temp.size() != 0) {
            Supplementaries.LOGGER.info("Loaded " + temp.size() + " flute songs");
        }
    }

    private static void addSong(Song song) {
        SONGS.put(song.getName(), song);
        SONG_WEIGHTED_LIST.add((class_6008.class_6010<String>)class_6008.method_34980((Object)song.getName(), (int)song.getWeight()));
    }

    public static void acceptClientSongs(List<Song> songs) {
        SONGS.clear();
        SONG_WEIGHTED_LIST.clear();
        songs.forEach(SongsManager::addSong);
    }

    public static void sendDataToClient(class_3222 player) {
        NetworkHandler.CHANNEL.sendToClientPlayer(player, (Message)new ClientBoundSyncSongsPacket(SONGS.values()));
    }

    public static Song setCurrentlyPlaying(UUID id, String songKey) {
        Song song = SONGS.getOrDefault(songKey, Song.EMPTY);
        CURRENTLY_PAYING.put(id, song);
        song.validatePlayReady();
        return song;
    }

    public static void clearCurrentlyPlaying(UUID id) {
        CURRENTLY_PAYING.remove(id);
    }

    @NotNull
    private static String selectRandomSong(class_5819 random) {
        Optional song = class_6011.method_34986((class_5819)random, SONG_WEIGHTED_LIST);
        return song.map(class_6008.class_6010::method_34983).orElseGet(() -> "");
    }

    public static void playRandomSong(class_1799 stack, InstrumentItem instrument, class_1309 entity, long timeSinceStarted) {
        Song song;
        UUID id = entity.method_5667();
        if (!CURRENTLY_PAYING.containsKey(id)) {
            String res = null;
            if (stack.method_7938()) {
                String name = stack.method_7964().getString().toLowerCase(Locale.ROOT);
                for (String v : SONGS.keySet()) {
                    if (!v.equals(name)) continue;
                    res = v;
                    break;
                }
            }
            if (res == null) {
                res = SongsManager.selectRandomSong(entity.method_37908().field_9229);
            }
            song = SongsManager.setCurrentlyPlaying(id, res);
        } else {
            song = CURRENTLY_PAYING.get(id);
        }
        SongsManager.playSong(instrument, entity, song, timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrumentItem, class_1309 entity, String sandstorm, long timeSinceStarted) {
        return SongsManager.playSong(instrumentItem, entity, SONGS.getOrDefault(sandstorm, Song.EMPTY), timeSinceStarted);
    }

    public static boolean playSong(InstrumentItem instrument, class_1309 entity, Song song, long timeSinceStarted) {
        IntList notes;
        boolean played = false;
        if (timeSinceStarted % (long)song.getTempo() == 0L && !(notes = song.getNoteToPlay(timeSinceStarted)).isEmpty() && notes.getInt(0) > 0) {
            NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntityAndSelf((class_1297)entity, (Message)new ClientBoundPlaySongNotesPacket(notes, entity));
            played = true;
        }
        return played;
    }

    public static void startRecording(class_2766[] whitelist) {
        RECORDING.clear();
        isRecording = true;
        WHITELIST.clear();
        WHITELIST.addAll(List.of(whitelist));
    }

    public static String stopRecording(class_1937 level, String name, int speedup) {
        int n;
        isRecording = false;
        long start = Long.MAX_VALUE;
        for (Long l : RECORDING.keySet()) {
            start = Math.min(start, l);
        }
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        for (Map.Entry<Long, List<Integer>> entry : RECORDING.entrySet()) {
            int notes = 0;
            List<Integer> noteList = entry.getValue();
            for (int i = 0; i < Math.min(4, noteList.size()); ++i) {
                notes = (int)((double)notes + (double)noteList.get(i).intValue() * Math.pow(100.0, i));
            }
            treeMap.put((int)(entry.getKey() - start), notes);
        }
        boolean bl = true;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int lastTime = 0;
        for (Map.Entry entry : treeMap.entrySet()) {
            int note = (Integer)entry.getValue();
            int key = (Integer)entry.getKey();
            int interval = -(key - lastTime);
            lastTime = key;
            if (interval != 0) {
                hashSet.add(-interval);
                if (-interval > n) {
                    n = -interval;
                }
                arrayList.add(interval);
            }
            arrayList.add(note);
        }
        int GCD = 1;
        void div = n;
        while (div > 0) {
            void d = div--;
            boolean match = hashSet.stream().allMatch(arg_0 -> SongsManager.lambda$stopRecording$3((int)d, arg_0));
            if (!match) continue;
            GCD = Math.abs((int)div);
            break;
        }
        ArrayList<Integer> finalNotes = new ArrayList<Integer>();
        Iterator d = arrayList.iterator();
        while (d.hasNext()) {
            int i = (Integer)d.next();
            if (i < 0) {
                finalNotes.add(i / GCD);
                continue;
            }
            finalNotes.add(i);
        }
        if (((String)name).isEmpty()) {
            name = "recorded-" + start;
        }
        Song song = new Song((String)name, GCD, finalNotes, "recorded in-game", 100);
        SongsManager.saveRecordedSong(song);
        SONGS.clear();
        SONGS.put((String)name, song);
        if (!level.field_9236) {
            NetworkHandler.CHANNEL.sendToAllClientPlayers((Message)new ClientBoundSyncSongsPacket(SONGS.values()));
        }
        RECORDING.clear();
        return song.getTranslationKey();
    }

    public static void recordNote(class_1936 levelAccessor, class_2338 pos) {
        if (levelAccessor instanceof class_1937) {
            class_1937 level = (class_1937)levelAccessor;
            if (isRecording) {
                class_2680 state = level.method_8320(pos);
                SongsManager.recordNote(level, (Integer)state.method_11654((class_2769)class_2428.field_11324) + 1, (class_2766)state.method_11654((class_2769)class_2428.field_11325));
            }
        }
    }

    public static void recordNote(class_1937 level, int note, class_2766 instrument) {
        if (WHITELIST.isEmpty() || WHITELIST.contains(instrument)) {
            List notes = RECORDING.computeIfAbsent(level.method_8510(), t -> new ArrayList());
            notes.add(note);
        }
    }

    private static void saveRecordedSong(Song song) {
        File folder = PlatHelper.getGamePath().resolve("recorded_songs").toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        File exportPath = new File(folder, song.getTranslationKey() + ".json");
        try (FileWriter writer = new FileWriter(exportPath);){
            DataResult r = Song.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)song);
            r.result().ifPresent(a -> GSON.toJson((JsonElement)a.getAsJsonObject(), (Appendable)writer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

