/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.client.gui.stats.panel;

import io.github.thecsdev.betterstats.api.client.gui.panel.BSComponentPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.GeneralStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.ItemStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.MobStatWidget;
import io.github.thecsdev.betterstats.api.util.stats.SUItemStat;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public final class StatsSummaryPanel
extends BSComponentPanel {
    public static final int ENTRY_HEIGHT = GeneralStatWidget.HEIGHT;
    private final List<class_2561[]> entries = new ArrayList<class_2561[]>();
    protected int columnCount = 2;

    public StatsSummaryPanel(int x, int y, int width) {
        this(x, y, width, 10 + ENTRY_HEIGHT * 3);
    }

    public StatsSummaryPanel(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.scrollFlags = 4;
        this.scrollPadding = 5;
    }

    public final void setColumnCount(int columnCount) {
        this.columnCount = class_3532.method_15340((int)columnCount, (int)1, (int)5);
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void clearEntries() {
        this.entries.clear();
    }

    public final void addEntry(@Nullable class_2561 left, @Nullable class_2561 right) {
        this.addEntry(left, null, right);
    }

    public final void addEntry(@Nullable class_2561 left, @Nullable class_2561 center, @Nullable class_2561 right) {
        this.entries.add(new class_2561[]{left, center, right});
    }

    public final void summarizeItemStats(Iterable<SUItemStat> itemStats) {
        this.clearEntries();
        long mined = 0L;
        long crafted = 0L;
        long used = 0L;
        long broken = 0L;
        long pickedUp = 0L;
        long dropped = 0L;
        for (SUItemStat itemStat : itemStats) {
            mined += (long)itemStat.mined;
            crafted += (long)itemStat.crafted;
            used += (long)itemStat.used;
            broken += (long)itemStat.broken;
            pickedUp += (long)itemStat.pickedUp;
            dropped += (long)itemStat.dropped;
        }
        this.addEntry(ItemStatWidget.TEXT_STAT_MINED, (class_2561)TextUtils.literal((String)Long.toString(mined)));
        this.addEntry(ItemStatWidget.TEXT_STAT_CRAFTED, (class_2561)TextUtils.literal((String)Long.toString(crafted)));
        this.addEntry(ItemStatWidget.TEXT_STAT_USED, (class_2561)TextUtils.literal((String)Long.toString(used)));
        this.addEntry(ItemStatWidget.TEXT_STAT_BROKEN, (class_2561)TextUtils.literal((String)Long.toString(broken)));
        this.addEntry(ItemStatWidget.TEXT_STAT_PICKED_UP, (class_2561)TextUtils.literal((String)Long.toString(pickedUp)));
        this.addEntry(ItemStatWidget.TEXT_STAT_DROPPED, (class_2561)TextUtils.literal((String)Long.toString(dropped)));
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    public final void summarizeMobStats(Iterable<SUMobStat> mobStats) {
        this.clearEntries();
        long kills = 0L;
        long deaths = 0L;
        for (SUMobStat mobStat : mobStats) {
            kills += (long)mobStat.kills;
            deaths += (long)mobStat.deaths;
        }
        this.addEntry(MobStatWidget.TEXT_STAT_KILLS, (class_2561)TextUtils.literal((String)Long.toString(kills)));
        this.addEntry(MobStatWidget.TEXT_STAT_DEATHS, (class_2561)TextUtils.literal((String)Long.toString(deaths)));
        if (this.getParentTScreen() != null) {
            this.refresh();
        }
    }

    protected final void init() {
        int sp = this.getScrollPadding();
        int entryWidth = (this.getWidth() - sp * 2) / Math.max(this.columnCount, 1);
        int row = 0;
        int column = 0;
        for (class_2561[] entry : this.entries) {
            int eX = sp + column * entryWidth;
            int eY = sp + row * ENTRY_HEIGHT;
            int ha = 0;
            for (class_2561 entryText : entry) {
                ++ha;
                if (entryText == null) continue;
                TLabelElement lbl = new TLabelElement(eX, eY, entryWidth, ENTRY_HEIGHT, entryText);
                lbl.setTextSideOffset(5);
                switch (ha) {
                    case 1: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
                        break;
                    }
                    case 2: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
                        break;
                    }
                    case 3: {
                        lbl.setTextHorizontalAlignment(HorizontalAlignment.RIGHT);
                        break;
                    }
                }
                this.addChild((TElement)lbl, true);
            }
            if (++column < this.columnCount) continue;
            column = 0;
            ++row;
        }
    }

    public final void autoHeight() {
        int rows = (int)Math.ceil((double)this.entries.size() / (double)Math.max(this.columnCount, 1));
        int height = rows * ENTRY_HEIGHT + this.getScrollPadding() * 2;
        this.setSize(this.getWidth(), height);
    }
}

