/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.api.registry;

import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class BSRegistries {
    public static final Map<String, Function<class_2960, String>> ITEM_WIKIS = new TreeMap<String, Function<class_2960, String>>(String.CASE_INSENSITIVE_ORDER);
    public static final Map<String, Function<class_2960, String>> MOB_WIKIS = new TreeMap<String, Function<class_2960, String>>(String.CASE_INSENSITIVE_ORDER);

    private BSRegistries() {
    }

    @Nullable
    public static String getItemWikiURL(class_2960 itemId) throws NullPointerException {
        Objects.requireNonNull(itemId);
        Function<class_2960, String> supplier = ITEM_WIKIS.get(itemId.method_12836());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(itemId);
    }

    @Nullable
    public static String getMobWikiURL(class_2960 entityId) throws NullPointerException {
        Objects.requireNonNull(entityId);
        Function<class_2960, String> supplier = MOB_WIKIS.get(entityId.method_12836());
        if (supplier == null) {
            return null;
        }
        return supplier.apply(entityId);
    }

    static {
        String mc = new class_2960("air").method_12836();
        ITEM_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.method_12832());
        MOB_WIKIS.put(mc, id -> "https://minecraft.wiki/" + id.method_12832());
    }
}

