/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.betterstats.client.gui.stats.tabs;

import io.github.thecsdev.betterstats.api.client.gui.stats.panel.StatsSummaryPanel;
import io.github.thecsdev.betterstats.api.client.gui.stats.widget.MobStatWidget;
import io.github.thecsdev.betterstats.api.client.gui.util.StatsTabUtils;
import io.github.thecsdev.betterstats.api.client.registry.StatsTab;
import io.github.thecsdev.betterstats.api.client.util.StatFilterSettings;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterGroupBy;
import io.github.thecsdev.betterstats.api.util.enumerations.FilterSortMobsBy;
import io.github.thecsdev.betterstats.api.util.io.IStatsProvider;
import io.github.thecsdev.betterstats.api.util.stats.SUMobStat;
import io.github.thecsdev.betterstats.client.BetterStatsClient;
import io.github.thecsdev.betterstats.client.gui.screen.hud.BetterStatsHudScreen;
import io.github.thecsdev.betterstats.client.gui.screen.hud.entry.StatsHudMobEntry;
import io.github.thecsdev.betterstats.client.gui.stats.tabs.BSStatsTab;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.config.TConfigPanelBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;

@Virtual
@ApiStatus.Internal
public class MobStatsTab
extends BSStatsTab<SUMobStat> {
    @Override
    @Virtual
    public class_2561 getName() {
        return TextUtils.translatable((String)"stat.mobsButton", (Object[])new Object[0]);
    }

    @Override
    @Virtual
    public void initStats(StatsTab.StatsInitContext initContext) {
        TPanelElement panel = initContext.getStatsPanel();
        IStatsProvider stats = initContext.getStatsProvider();
        StatFilterSettings filters = initContext.getFilterSettings();
        Predicate<SUMobStat> predicate = this.getPredicate(initContext.getFilterSettings());
        FilterGroupBy filter_group = (FilterGroupBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_GROUP, (Object)FilterGroupBy.DEFAULT));
        FilterSortMobsBy filter_sort = (FilterSortMobsBy)((Object)filters.getPropertyOrDefault(StatsTabUtils.FILTER_ID_SORT_MOBS, (Object)FilterSortMobsBy.DEFAULT));
        Map<Object, Object> statGroups = null;
        switch (filter_group) {
            case ALL: {
                statGroups = new LinkedHashMap();
                statGroups.put(TextUtils.literal((String)"*"), SUMobStat.getMobStats(stats, predicate));
                break;
            }
            default: {
                statGroups = SUMobStat.getMobStatsByModGroupsB(stats, predicate);
            }
        }
        filter_sort.sortMobStats(statGroups);
        for (Map.Entry<Object, Object> statGroup : statGroups.entrySet()) {
            class_2561 group = (class_2561)statGroup.getKey();
            StatsTabUtils.initGroupLabel(panel, (class_2561)(group != null ? group : TextUtils.literal((String)"*")));
            MobStatsTab.initStats(panel, (Collection)statGroup.getValue(), widget -> this.processWidget((MobStatWidget)((Object)widget)));
        }
        StatsSummaryPanel summary = MobStatsTab.initStatsSummary(panel);
        if (summary != null) {
            summary.summarizeMobStats(statGroups.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
            summary.autoHeight();
        }
    }

    @Override
    @Virtual
    protected void initExtraFilters(StatsTab.FiltersInitContext initContext) {
        StatsTabUtils.initGroupByFilter(initContext);
        StatsTabUtils.initSortMobsByFilter(initContext);
    }

    @Virtual
    protected void processWidget(MobStatWidget widget) {
        widget.eContextMenu.register((__, cMenu) -> {
            cMenu.addButton((class_2561)TextUtils.translatable((String)"betterstats.client.gui.screen.hud.betterstatshudscreen.pin_stat", (Object[])new Object[0]), ___ -> {
                BetterStatsHudScreen hud = BetterStatsHudScreen.getInstance();
                hud.setParentScreen(BetterStatsClient.MC_CLIENT.field_1755);
                hud.addEntry(new StatsHudMobEntry((SUMobStat)widget.getStat()));
                BetterStatsClient.MC_CLIENT.method_1507(hud.getAsScreen());
            });
            cMenu.addButton((class_2561)TextUtils.translatable((String)"mco.selectServer.close", (Object[])new Object[0]), ___ -> {});
        });
    }

    protected static void initStats(TPanelElement panel, Collection<SUMobStat> stats, Consumer<MobStatWidget> processWidget) {
        int wmp = panel.getWidth() - panel.getScrollPadding() * 2;
        int nextX = panel.getScrollPadding();
        int nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY();
        for (SUMobStat stat : stats) {
            MobStatWidget statElement = new MobStatWidget(nextX, nextY, stat);
            panel.addChild((TElement)statElement, true);
            if (processWidget != null) {
                processWidget.accept(statElement);
            }
            if ((nextX += 58) + 55 < wmp) continue;
            nextX = panel.getScrollPadding();
            nextY = TConfigPanelBuilder.nextPanelBottomY((TPanelElement)panel) - panel.getY() + 3;
        }
    }
}

