/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.elementalcreepers.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import me.luligabi.elementalcreepers.common.ModConfig;
import me.luligabi.elementalcreepers.common.block.TntRegistry;
import me.luligabi.elementalcreepers.common.entity.creeper.CreeperRegistry;
import me.luligabi.elementalcreepers.common.item.ItemRegistry;
import me.luligabi.elementalcreepers.common.item.SpawnEggRegistry;
import me.luligabi.elementalcreepers.common.misc.DispenserLogicRegistry;
import me.luligabi.elementalcreepers.common.misc.NaturalSpawningRegistry;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementalCreepers
implements ModInitializer {
    public static final String MOD_ID = "elementalcreepers";
    public static final class_5321<class_1761> ITEM_GROUP = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)new class_2960("elementalcreepers", "category"));
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Elemental Creepers: Refabricated");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File(String.format("%s%selementalcreepers.json", FabricLoader.getInstance().getConfigDir(), File.separator));
    public static final ModConfig CONFIG = ElementalCreepers.createConfig();

    public void onInitialize() {
        CreeperRegistry.init();
        NaturalSpawningRegistry.init();
        SpawnEggRegistry.init();
        TntRegistry.init();
        ItemRegistry.init();
        DispenserLogicRegistry.init();
        class_2378.method_39197((class_2378)class_7923.field_44687, ITEM_GROUP, (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.elementalcreepers.category")).method_47320(() -> new class_1799((class_1935)class_1802.field_8503)).method_47317((ctx, entries) -> {
            entries.method_45421((class_1935)SpawnEggRegistry.WATER_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.FIRE_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.EARTH_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.AIR_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.ELECTRIC_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.LIGHT_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.DARK_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.ICE_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.MAGMA_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.HYDROGEN_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.REVERSE_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.MINER_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.ILLUSION_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.FIREWORK_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.COOKIE_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)SpawnEggRegistry.RAINBOW_CREEPER_SPAWN_EGG);
            entries.method_45421((class_1935)TntRegistry.WATER_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.FIRE_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.EARTH_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.AIR_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.ELECTRIC_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.LIGHT_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.DARK_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.ICE_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.MAGMA_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.HYDROGEN_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.REVERSE_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.MINER_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.ILLUSION_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.FIREWORK_TNT_BLOCK);
            entries.method_45421((class_1935)TntRegistry.COOKIE_TNT_BLOCK);
            entries.method_45421((class_1935)ItemRegistry.WATER_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.FIRE_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.EARTH_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.AIR_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.ELECTRIC_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.LIGHT_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.DARK_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.ICE_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.MAGMA_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.HYDROGEN_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.REVERSE_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.MINER_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.ILLUSION_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.FIREWORK_GUNPOWDER);
            entries.method_45421((class_1935)ItemRegistry.COOKIE_GUNPOWDER);
        }).method_47324());
        LOGGER.info("Mod Initialized!");
    }

    private static ModConfig createConfig() {
        ModConfig finalConfig;
        LOGGER.info("Trying to read config file...");
        try {
            if (CONFIG_FILE.createNewFile()) {
                LOGGER.info("No config file found, creating a new one...");
                ElementalCreepers.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)new ModConfig()))));
                finalConfig = new ModConfig();
                LOGGER.info("Successfully created default config file.");
            } else {
                LOGGER.info("A config file was found, loading it..");
                finalConfig = (ModConfig)GSON.fromJson(new String(Files.readAllBytes(CONFIG_FILE.toPath())), ModConfig.class);
                if (finalConfig == null) {
                    throw new NullPointerException("The config file was empty.");
                }
                LOGGER.info("Successfully loaded config file.");
            }
        }
        catch (Exception e) {
            LOGGER.error("There was an error creating/loading the config file!", (Throwable)e);
            finalConfig = new ModConfig();
            LOGGER.warn("Defaulting to original config.");
        }
        return finalConfig;
    }

    public static void saveConfig(ModConfig modConfig) {
        try {
            ElementalCreepers.writeConfig(GSON.toJson(JsonParser.parseString((String)GSON.toJson((Object)modConfig))));
            LOGGER.info("Saved new config file.");
        }
        catch (Exception e) {
            LOGGER.error("There was an error saving the config file!", (Throwable)e);
        }
    }

    private static void writeConfig(String json) {
        try (PrintWriter printWriter = new PrintWriter(CONFIG_FILE);){
            printWriter.write(json);
            printWriter.flush();
        }
        catch (IOException e) {
            LOGGER.error("Failed to write config file", (Throwable)e);
        }
    }
}

