/*
 * Decompiled with CFR 0.152.
 */
package me.luligabi.elementalcreepers.common.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import me.luligabi.elementalcreepers.common.ElementalCreepers;
import me.luligabi.elementalcreepers.common.block.TntRegistry;
import me.luligabi.elementalcreepers.common.entity.creeper.ElementalCreeperEntity;
import me.luligabi.elementalcreepers.common.entity.tnt.FakeIllusionTntEntity;
import me.luligabi.elementalcreepers.common.misc.TagRegistry;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1671;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2680;

public class ExplosionEffects {
    public static void waterExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.waterCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        if (entityWorld.method_8320(blockPos).method_26215() && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            entityWorld.method_8501(blockPos, class_2246.field_10382.method_9564());
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void fireExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.fireCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        if (entityWorld.method_8320(blockPos).method_26215() && !entityWorld.method_8320(new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y - 1.0), (int)(entityZ + (double)z))).method_26215() && new Random().nextBoolean()) {
                            entityWorld.method_8501(blockPos, class_2246.field_10036.method_9564());
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void earthExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.earthCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        if (entityWorld.method_8320(blockPos).method_26215() && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            switch (new Random().nextInt(5) + 1) {
                                case 1: {
                                    entityWorld.method_8501(blockPos, class_2246.field_10566.method_9564());
                                    break;
                                }
                                case 2: {
                                    entityWorld.method_8501(blockPos, class_2246.field_10253.method_9564());
                                    break;
                                }
                                default: {
                                    entityWorld.method_8501(blockPos, class_2246.field_10124.method_9564());
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void airExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.airCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        for (class_1297 entities : entityWorld.method_8335(null, new class_238(entityX - 5.0, entityY - 5.0, entityZ - 5.0, entityX + 5.0, entityY + 5.0, entityZ + 5.0))) {
            if (!(entities instanceof class_1309)) continue;
            entities.method_18800(0.0, radius, 0.0);
        }
    }

    public static void electricExplosionEffect(class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        class_1538 lightningEntity = (class_1538)class_1299.field_6112.method_5883(entityWorld);
        if (lightningEntity != null) {
            lightningEntity.method_29498(!entityWorld.method_8450().method_8355(class_1928.field_19388));
        }
        lightningEntity.method_24203(entityX, entityY, entityZ);
        entityWorld.method_8649((class_1297)lightningEntity);
    }

    public static void lightExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.lightCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        if (entityWorld.method_8320(blockPos).method_26215() && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            switch (new Random().nextInt(5) + 1) {
                                case 1: 
                                case 2: {
                                    entityWorld.method_8501(blockPos, class_2246.field_10171.method_9564());
                                    break;
                                }
                                case 3: 
                                case 4: 
                                case 5: {
                                    entityWorld.method_8501(blockPos, class_2246.field_10124.method_9564());
                                }
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        for (class_1297 entities : entityWorld.method_8335(null, new class_238(entityX - 5.0, entityY - 5.0, entityZ - 5.0, entityX + 5.0, entityY + 5.0, entityZ + 5.0))) {
            if (!(entities instanceof class_1309)) continue;
            ((class_1309)entities).method_6092(new class_1293(class_1294.field_5912, 800, 0));
        }
    }

    public static void darkExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.darkCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius);
            while ((double)x <= radius) {
                int y = (int)(-radius);
                while ((double)y <= radius) {
                    int z = (int)(-radius);
                    while ((double)z <= radius) {
                        class_2248 lightBlock;
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        class_2680 state = entityWorld.method_8320(blockPos);
                        if (state != null && state.method_26204() != null && (lightBlock = state.method_26204()) != null && !lightBlock.method_9564().method_31709() && (float)state.method_26213() > 7.5f && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            entityWorld.method_8501(blockPos, class_2246.field_10124.method_9564());
                            entityWorld.method_8649((class_1297)new class_1542(entityWorld, entityX, entityY, entityZ, new class_1799((class_1935)lightBlock.method_8389(), 1)));
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        for (class_1297 entities : entityWorld.method_8335(null, new class_238(entityX - 5.0, entityY - 5.0, entityZ - 5.0, entityX + 5.0, entityY + 5.0, entityZ + 5.0))) {
            if (!(entities instanceof class_1309)) continue;
            ((class_1309)entities).method_6092(new class_1293(class_1294.field_5919, 300, 0));
        }
    }

    public static void iceExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.iceCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        if (Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                            if (entityWorld.method_8320(blockPos).method_26215() && !entityWorld.method_8320(new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y - 1.0), (int)(entityZ + (double)z))).method_26215()) {
                                if (new Random().nextBoolean()) {
                                    entityWorld.method_8501(blockPos, class_2246.field_10491.method_9564());
                                } else {
                                    entityWorld.method_8501(blockPos, class_2246.field_10477.method_9564());
                                }
                            } else if (entityWorld.method_8320(blockPos) == class_2246.field_10382.method_9564()) {
                                entityWorld.method_8501(blockPos, class_2246.field_10295.method_9564());
                            } else if (entityWorld.method_8320(blockPos) == class_2246.field_10164.method_9564()) {
                                entityWorld.method_8501(blockPos, class_2246.field_10540.method_9564());
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
        for (class_1297 entities : entityWorld.method_8335(null, new class_238(entityX - 5.0, entityY - 5.0, entityZ - 5.0, entityX + 5.0, entityY + 5.0, entityZ + 5.0))) {
            if (!(entities instanceof class_1309)) continue;
            ((class_1309)entities).method_6092(new class_1293(class_1294.field_5909, 800, 1));
        }
    }

    public static void magmaExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.magmaCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                int y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    int z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        if (entityWorld.method_8320(blockPos).method_26215() && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                            entityWorld.method_8501(blockPos, class_2246.field_10164.method_9564());
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void hydrogenExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.hydrogenCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, (float)radius, entityWorld.method_8450().method_8355(class_1928.field_19388) ? class_1937.class_7867.field_40891 : class_1937.class_7867.field_40888);
    }

    public static void reverseExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.reverseCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            int z;
            int y;
            class_2680[][][] states = new class_2680[(int)(radius * 2.0 + 2.0)][(int)(radius * 2.0 + 2.0)][(int)(radius * 2.0 + 2.0)];
            int x = (int)(-radius) - 1;
            while ((double)x <= radius) {
                y = (int)(-radius) - 1;
                while ((double)y <= radius) {
                    z = (int)(-radius) - 1;
                    while ((double)z <= radius) {
                        class_2248 id;
                        int ax = (int)((double)x + radius + 1.0);
                        int ay = (int)((double)y + radius + 1.0);
                        int az = (int)((double)z + radius + 1.0);
                        double ex = entityX + (double)x;
                        double ey = entityY + (double)y;
                        double ez = entityZ + (double)z;
                        class_2338 blockPos = new class_2338((int)ex, (int)ey, (int)ez);
                        class_2680 state = entityWorld.method_8320(blockPos);
                        if (state != null && state.method_26204() != null && (id = state.method_26204()) != class_2246.field_9987) {
                            states[ax][ay][az] = null;
                            if (id != null && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius && ey > -1.0) {
                                states[ax][ay][az] = state;
                            }
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
            x = (int)(-radius - 1.0);
            while ((double)x <= radius) {
                y = (int)(-radius - 1.0);
                while ((double)y <= radius) {
                    z = (int)(-radius - 1.0);
                    while ((double)z <= radius) {
                        class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                        class_2680 state = states[(int)((double)x + radius + 1.0)][(int)(2.0 * radius - ((double)y + radius))][(int)((double)z + radius + 1.0)];
                        if (state != null && state.method_26204() != null && entityY + (double)y > 5.0) {
                            entityWorld.method_8652(blockPos, state, 3);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public static void minerExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        double radius = ElementalCreepers.CONFIG.minerCreeperRadius;
        if (entity instanceof ElementalCreeperEntity) {
            radius = ((ElementalCreeperEntity)entity).isCharged() ? radius * 1.5 : radius;
        }
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        if (!entityWorld.method_8450().method_8355(class_1928.field_19388)) {
            return;
        }
        int x = (int)(-radius);
        while ((double)x <= radius) {
            int y = (int)(-radius);
            while ((double)y <= radius) {
                int z = (int)(-radius);
                while ((double)z <= radius) {
                    class_2338 blockPos = new class_2338((int)(entityX + (double)x), (int)(entityY + (double)y), (int)(entityZ + (double)z));
                    class_2680 state = entityWorld.method_8320(blockPos);
                    if (state != null && state.method_26204() != null && state.method_26164(TagRegistry.MINER_CREEPER_EXPLODABLE) && Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0)) <= radius) {
                        entityWorld.method_8501(blockPos, class_2246.field_10124.method_9564());
                        if (new Random().nextBoolean()) {
                            entityWorld.method_8649((class_1297)new class_1542(entityWorld, entityX, entityY, entityZ, new class_1799((class_1935)state.method_26204().method_8389(), 1)));
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static void fireworkExplosionEffect(class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        class_1799 fireWork = new class_1799((class_1935)class_1802.field_8639);
        try {
            fireWork.method_7959("Fireworks", (class_2520)class_2522.method_10718((String)"{Explosions:[{Type:3,Flicker:1,Colors:[I;4312372],FadeColors:[I;4312372]}],Flight:1}"));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        class_1671 fireworkEntity = new class_1671(entityWorld, entityX, entityY, entityZ, fireWork);
        fireworkEntity.method_24203(entityX, entityY, entityZ);
        entityWorld.method_8649((class_1297)fireworkEntity);
    }

    public static void cookieExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 0.0f, class_1937.class_7867.field_40888);
        entityWorld.method_8649((class_1297)new class_1542(entityWorld, entityX, entityY, entityZ, new class_1799((class_1935)class_1802.field_8423, new Random().nextInt(3) + 2)));
    }

    public static void rainbowExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        switch (entityWorld.method_8409().method_43048(14) + 1) {
            case 1: {
                ExplosionEffects.waterExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 2: {
                ExplosionEffects.fireExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 3: {
                ExplosionEffects.earthExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 4: {
                ExplosionEffects.airExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 5: {
                ExplosionEffects.electricExplosionEffect(entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 6: {
                ExplosionEffects.lightExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 7: {
                ExplosionEffects.darkExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 8: {
                ExplosionEffects.iceExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 9: {
                ExplosionEffects.magmaExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 10: {
                ExplosionEffects.hydrogenExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 11: {
                ExplosionEffects.reverseExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 12: {
                ExplosionEffects.minerExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 13: {
                ExplosionEffects.fireworkExplosionEffect(entityWorld, entityX, entityY, entityZ);
                break;
            }
            case 14: {
                ExplosionEffects.cookieExplosionEffect(entity, entityWorld, entityX, entityY, entityZ);
            }
        }
    }

    public static void illusionTNTExplosionEffect(class_1297 entity, class_1937 entityWorld, double entityX, double entityY, double entityZ) {
        for (int i = 0; i < 4; ++i) {
            FakeIllusionTntEntity fakeIllusionTntEntity = new FakeIllusionTntEntity(TntRegistry.FAKE_ILLUSION_TNT_ENTITY, entityWorld);
            fakeIllusionTntEntity.method_24203(entityX, entityY, entityZ);
            entityWorld.method_8649((class_1297)fakeIllusionTntEntity);
            fakeIllusionTntEntity.method_18800(-Math.sin(entityWorld.field_9229.method_43058() * 6.2831854820251465) * 0.02, 0.2f, -Math.cos(entityWorld.field_9229.method_43058() * 6.2831854820251465) * 0.02);
        }
        entity.method_18800(0.0, 0.5, 0.0);
        entityWorld.method_8437(entity, entityX, entityY, entityZ, 4.0f, class_1937.class_7867.field_40891);
    }
}

