/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting;

import com.google.common.base.Objects;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4590;
import org.joml.Matrix4f;

public class SurroundingBlockData {
    private final Map<class_2350, SideConnections> connections;
    private final int hashCode;

    public static SurroundingBlockData create(class_1920 level, class_2338 pos, class_4590 rotation, List<ConnectionPredicate> predicates) {
        class_4590 inverseRotation = rotation.method_22935();
        Matrix4f rotationMatrix = inverseRotation == null ? class_4590.method_22931().method_22936() : rotation.method_22936();
        Matrix4f inverseRotationMatrix = inverseRotation == null ? class_4590.method_22931().method_22936() : inverseRotation.method_22936();
        EnumMap<class_2350, SideConnections> connections = new EnumMap<class_2350, SideConnections>(class_2350.class);
        for (class_2350 side : class_2350.values()) {
            connections.put(side, SurroundingBlockData.getConnections(side, rotationMatrix, inverseRotationMatrix, level, pos, predicates));
        }
        return new SurroundingBlockData(connections);
    }

    private static SideConnections getConnections(class_2350 side, Matrix4f rotation, Matrix4f inverseRotation, class_1920 level, class_2338 pos, List<ConnectionPredicate> predicates) {
        class_2350 down;
        class_2350 up;
        class_2350 right;
        class_2350 left;
        class_2350 originalSide = class_2350.method_23225((Matrix4f)inverseRotation, (class_2350)side);
        if (originalSide.method_10166() == class_2350.class_2351.field_11052) {
            left = class_2350.field_11039;
            right = class_2350.field_11034;
            up = originalSide == class_2350.field_11036 ? class_2350.field_11043 : class_2350.field_11035;
            down = originalSide == class_2350.field_11036 ? class_2350.field_11035 : class_2350.field_11043;
        } else {
            left = originalSide.method_10170();
            right = originalSide.method_10160();
            up = class_2350.field_11036;
            down = class_2350.field_11033;
        }
        left = class_2350.method_23225((Matrix4f)rotation, (class_2350)left);
        right = class_2350.method_23225((Matrix4f)rotation, (class_2350)right);
        up = class_2350.method_23225((Matrix4f)rotation, (class_2350)up);
        down = class_2350.method_23225((Matrix4f)rotation, (class_2350)down);
        class_2680 self = level.method_8320(pos);
        boolean connectTop = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(up), ConnectionDirection.TOP, predicates);
        boolean connectTopRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(up).method_10093(right), ConnectionDirection.TOP_RIGHT, predicates);
        boolean connectRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(right), ConnectionDirection.RIGHT, predicates);
        boolean connectBottomRight = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(down).method_10093(right), ConnectionDirection.BOTTOM_RIGHT, predicates);
        boolean connectBottom = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(down), ConnectionDirection.BOTTOM, predicates);
        boolean connectBottomLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(down).method_10093(left), ConnectionDirection.BOTTOM_LEFT, predicates);
        boolean connectLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(left), ConnectionDirection.LEFT, predicates);
        boolean connectTopLeft = SurroundingBlockData.shouldConnect(level, side, originalSide, self, pos.method_10093(up).method_10093(left), ConnectionDirection.TOP_LEFT, predicates);
        return new SideConnections(side, connectTop, connectTopRight, connectRight, connectBottomRight, connectBottom, connectBottomLeft, connectLeft, connectTopLeft);
    }

    private static boolean shouldConnect(class_1920 level, class_2350 side, class_2350 originalSide, class_2680 self, class_2338 neighborPos, ConnectionDirection direction, List<ConnectionPredicate> predicates) {
        class_2680 otherState = level.method_8320(neighborPos);
        class_2680 stateInFront = level.method_8320(neighborPos.method_10093(side));
        return predicates.stream().anyMatch(predicate -> predicate.shouldConnect(originalSide, self, otherState, stateInFront, direction));
    }

    public SurroundingBlockData(Map<class_2350, SideConnections> connections) {
        this.connections = connections;
        this.hashCode = this.connections.hashCode();
    }

    public SideConnections getConnections(class_2350 side) {
        return this.connections.get(side);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj instanceof SurroundingBlockData && this.hashCode == ((SurroundingBlockData)obj).hashCode;
    }

    public static final class SideConnections {
        public final class_2350 side;
        public final boolean top;
        public final boolean topRight;
        public final boolean right;
        public final boolean bottomRight;
        public final boolean bottom;
        public final boolean bottomLeft;
        public final boolean left;
        public final boolean topLeft;

        public SideConnections(class_2350 side, boolean top, boolean topRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean topLeft) {
            this.side = side;
            this.top = top;
            this.topRight = topRight;
            this.right = right;
            this.bottomRight = bottomRight;
            this.bottom = bottom;
            this.bottomLeft = bottomLeft;
            this.left = left;
            this.topLeft = topLeft;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SideConnections that = (SideConnections)o;
            return this.left == that.left && this.right == that.right && this.top == that.top && this.topLeft == that.topLeft && this.topRight == that.topRight && this.bottom == that.bottom && this.bottomLeft == that.bottomLeft && this.bottomRight == that.bottomRight && this.side == that.side;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.side, this.left, this.right, this.top, this.topLeft, this.topRight, this.bottom, this.bottomLeft, this.bottomRight});
        }
    }
}

