/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.connecting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.texture.SpriteCreationContext;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.texture.data.ConnectingTextureLayout;
import com.supermartijn642.fusion.texture.types.connecting.ConnectingTextureSprite;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_1058;

public class ConnectingTextureType
implements TextureType<ConnectingTextureLayout> {
    @Override
    public ConnectingTextureLayout deserialize(JsonObject json) throws JsonParseException {
        ConnectingTextureLayout layout = ConnectingTextureLayout.FULL;
        if (json.has("layout")) {
            if (!json.get("layout").isJsonPrimitive() || !json.getAsJsonPrimitive("layout").isString()) {
                throw new JsonParseException("Property 'layout' must be a string!");
            }
            String layoutString = json.get("layout").getAsString();
            try {
                layout = ConnectingTextureLayout.valueOf(layoutString.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new JsonParseException("Property 'layout' must be one of " + Arrays.toString((Object[])ConnectingTextureLayout.values()).toLowerCase(Locale.ROOT) + ", not '" + layoutString + "'!");
            }
        }
        return layout;
    }

    @Override
    public JsonObject serialize(ConnectingTextureLayout value) {
        if (value == ConnectingTextureLayout.FULL) {
            return null;
        }
        JsonObject json = new JsonObject();
        json.addProperty("layout", value.name().toLowerCase(Locale.ROOT));
        return json;
    }

    @Override
    public class_1058 createSprite(SpriteCreationContext context, ConnectingTextureLayout data) {
        class_1058 sprite = context.createOriginalSprite();
        int scale = ConnectingTextureType.getScaleFactor(data);
        sprite.field_5269 = sprite.field_5270 + (sprite.field_5269 - sprite.field_5270) / (float)scale;
        sprite.field_5267 = sprite.field_5268 + (sprite.field_5267 - sprite.field_5268) / (float)scale;
        return new ConnectingTextureSprite(sprite, data);
    }

    public static int getScaleFactor(ConnectingTextureLayout layout) {
        return layout == ConnectingTextureLayout.FULL ? 8 : 4;
    }

    public static int[] getStatePosition(ConnectingTextureLayout layout, boolean up, boolean upRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean upLeft) {
        if (layout == ConnectingTextureLayout.FULL) {
            return ConnectingTextureType.getStatePositionFull(up, upRight, right, bottomRight, bottom, bottomLeft, left, upLeft);
        }
        if (layout == ConnectingTextureLayout.SIMPLE) {
            return ConnectingTextureType.getStatePositionSimple(up, right, bottom, left);
        }
        throw new IllegalStateException("Unknown layout '" + layout + "'!");
    }

    public static int[] getStatePositionFull(boolean up, boolean upRight, boolean right, boolean bottomRight, boolean bottom, boolean bottomLeft, boolean left, boolean upLeft) {
        int[] uv = !(left || up || right || bottom) ? new int[]{0, 0} : (left && !up && !right && !bottom ? new int[]{3, 0} : (!left && up && !right && !bottom ? new int[]{0, 3} : (!left && !up && right && !bottom ? new int[]{1, 0} : (!left && !up && !right && bottom ? new int[]{0, 1} : (left && !up && right && !bottom ? new int[]{2, 0} : (!left && up && !right && bottom ? new int[]{0, 2} : (left && up && !right && !bottom ? (upLeft ? new int[]{3, 3} : new int[]{5, 1}) : (!left && up && right && !bottom ? (upRight ? new int[]{1, 3} : new int[]{4, 1}) : (!left && !up && right && bottom ? (bottomRight ? new int[]{1, 1} : new int[]{4, 0}) : (left && !up && !right && bottom ? (bottomLeft ? new int[]{3, 1} : new int[]{5, 0}) : (!left ? (upRight && bottomRight ? new int[]{1, 2} : (upRight ? new int[]{4, 2} : (bottomRight ? new int[]{6, 2} : new int[]{6, 0}))) : (!up ? (bottomLeft && bottomRight ? new int[]{2, 1} : (bottomLeft ? new int[]{7, 2} : (bottomRight ? new int[]{5, 2} : new int[]{7, 0}))) : (!right ? (upLeft && bottomLeft ? new int[]{3, 2} : (upLeft ? new int[]{7, 3} : (bottomLeft ? new int[]{5, 3} : new int[]{7, 1}))) : (!bottom ? (upLeft && upRight ? new int[]{2, 3} : (upLeft ? new int[]{4, 3} : (upRight ? new int[]{6, 3} : new int[]{6, 1}))) : (upLeft && upRight && bottomLeft && bottomRight ? new int[]{2, 2} : (!upLeft && upRight && bottomLeft && bottomRight ? new int[]{7, 5} : (upLeft && !upRight && bottomLeft && bottomRight ? new int[]{6, 5} : (upLeft && upRight && !bottomLeft && bottomRight ? new int[]{7, 4} : (upLeft && upRight && bottomLeft && !bottomRight ? new int[]{6, 4} : (!upLeft && upRight && !bottomRight && bottomLeft ? new int[]{0, 4} : (upLeft && !upRight && bottomRight && !bottomLeft ? new int[]{0, 5} : (!upLeft && !upRight && bottomRight && bottomLeft ? new int[]{3, 4} : (upLeft && !upRight && !bottomRight && bottomLeft ? new int[]{3, 5} : (upLeft && upRight && !bottomRight && !bottomLeft ? new int[]{2, 5} : (!upLeft && upRight && bottomRight && !bottomLeft ? new int[]{2, 4} : (upLeft ? new int[]{5, 5} : (upRight ? new int[]{4, 5} : (bottomRight ? new int[]{4, 4} : (bottomLeft ? new int[]{5, 4} : new int[]{1, 4})))))))))))))))))))))))))))));
        return uv;
    }

    public static int[] getStatePositionSimple(boolean up, boolean right, boolean bottom, boolean left) {
        int[] uv = !left && !up && !right && !bottom ? new int[]{0, 0} : (left && !up && !right && !bottom ? new int[]{3, 0} : (!left && up && !right && !bottom ? new int[]{3, 1} : (!left && !up && right && !bottom ? new int[]{2, 1} : (!left && !up && !right && bottom ? new int[]{2, 0} : (left && !up && right && !bottom ? new int[]{0, 1} : (!left && up && !right && bottom ? new int[]{1, 1} : (left && up && !right && !bottom ? new int[]{3, 3} : (!left && up && right && !bottom ? new int[]{2, 3} : (!left && !up && right && bottom ? new int[]{2, 2} : (left && !up && !right && bottom ? new int[]{3, 2} : (!left ? new int[]{0, 2} : (!up ? new int[]{1, 2} : (!right ? new int[]{1, 3} : (!bottom ? new int[]{0, 3} : new int[]{1, 0}))))))))))))));
        return uv;
    }
}

