/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory;

import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackInventory;
import net.minecraft.class_2487;

public class SettingsManager {
    private final ITravelersBackpackInventory inv;
    private byte[] craftingSettings = new byte[]{1, 1};
    private byte[] toolSlotsSettings = new byte[]{0};
    public static final byte CRAFTING = 0;
    public static final byte TOOL_SLOTS = 1;
    public static final int LOCK_CRAFTING_GRID = 0;
    public static final int RENDER_OVERLAY = 1;
    public static final int SHOW_TOOL_SLOTS = 0;
    private final String CRAFTING_SETTINGS = "CraftingSettings";
    private final String TOOL_SLOTS_SETTINGS = "ToolSlotsSettings";

    public SettingsManager(ITravelersBackpackInventory inv) {
        this.inv = inv;
    }

    public boolean isCraftingGridLocked() {
        return this.getByte((byte)0, 0) == 1;
    }

    public boolean renderOverlay() {
        return this.getByte((byte)0, 1) == 1;
    }

    public boolean showToolSlots() {
        return this.getByte((byte)1, 0) == 1;
    }

    public byte getByte(byte dataArray, int place) {
        if (dataArray == 0) {
            if (TravelersBackpackConfig.disableCrafting && place == 0) {
                return 0;
            }
            return this.craftingSettings[place];
        }
        if (dataArray == 1) {
            return this.toolSlotsSettings[place];
        }
        return 0;
    }

    public void set(byte selectedDataArray, int place, byte value) {
        byte[] dataArray = new byte[]{};
        if (selectedDataArray == 0) {
            dataArray = this.craftingSettings;
        }
        if (selectedDataArray == 1) {
            dataArray = this.toolSlotsSettings;
        }
        dataArray[place] = value;
        this.markDirty();
    }

    public void writeSettings(class_2487 compound) {
        compound.method_10570("CraftingSettings", this.craftingSettings);
        compound.method_10570("ToolSlotsSettings", this.toolSlotsSettings);
    }

    public void readSettings(class_2487 compound) {
        byte[] byArray;
        byte[] byArray2;
        if (compound.method_10545("CraftingSettings")) {
            byArray2 = compound.method_10547("CraftingSettings");
        } else {
            byte[] byArray3 = new byte[2];
            byArray3[0] = 1;
            byArray2 = byArray3;
            byArray3[1] = 1;
        }
        this.craftingSettings = byArray2;
        if (compound.method_10545("ToolSlotsSettings")) {
            byArray = compound.method_10547("ToolSlotsSettings");
        } else {
            byte[] byArray4 = new byte[1];
            byArray = byArray4;
            byArray4[0] = 0;
        }
        this.toolSlotsSettings = byArray;
    }

    public void markDirty() {
        if (this.inv.getScreenID() != 3) {
            this.inv.markDataDirty(9);
        } else {
            this.inv.method_5431();
        }
    }
}

