/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.world.features;

import com.mojang.serialization.Codec;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3341;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3542;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.features.features.DefaultFeature;
import org.betterx.bclib.api.v2.levelgen.structures.templatesystem.DestructionStructureProcessor;
import org.betterx.bclib.util.BlocksHelper;
import org.betterx.betterend.world.features.NBTFeatureConfig;
import org.betterx.worlds.together.tag.v3.CommonBlockTags;

public abstract class NBTFeature<FC extends NBTFeatureConfig>
extends class_3031<FC> {
    protected static final DestructionStructureProcessor DESTRUCTION = new DestructionStructureProcessor();

    public NBTFeature(Codec<FC> codec) {
        super(codec);
    }

    protected abstract class_3499 getStructure(FC var1, class_5281 var2, class_2338 var3, class_5819 var4);

    protected abstract boolean canSpawn(class_5281 var1, class_2338 var2, class_5819 var3);

    protected abstract class_2470 getRotation(class_5281 var1, class_2338 var2, class_5819 var3);

    protected abstract class_2415 getMirror(class_5281 var1, class_2338 var2, class_5819 var3);

    protected abstract int getYOffset(class_3499 var1, class_5281 var2, class_2338 var3, class_5819 var4);

    protected abstract TerrainMerge getTerrainMerge(class_5281 var1, class_2338 var2, class_5819 var3);

    protected abstract void addStructureData(class_3492 var1);

    protected class_2338 getGround(class_5281 world, class_2338 center) {
        class_6880 biome = world.method_23753(center);
        class_2960 id = BiomeAPI.getBiomeID((class_6880)biome);
        if (id.method_12836().contains("moutain") || id.method_12836().contains("lake")) {
            int y = this.getAverageY(world, center);
            return new class_2338(center.method_10263(), y, center.method_10260());
        }
        int y = this.getAverageYWG(world, center);
        return new class_2338(center.method_10263(), y, center.method_10260());
    }

    protected int getAverageY(class_5281 world, class_2338 center) {
        int y = DefaultFeature.getYOnSurface((class_5281)world, (int)center.method_10263(), (int)center.method_10260());
        y += DefaultFeature.getYOnSurface((class_5281)world, (int)(center.method_10263() - 2), (int)(center.method_10260() - 2));
        y += DefaultFeature.getYOnSurface((class_5281)world, (int)(center.method_10263() + 2), (int)(center.method_10260() - 2));
        y += DefaultFeature.getYOnSurface((class_5281)world, (int)(center.method_10263() - 2), (int)(center.method_10260() + 2));
        return (y += DefaultFeature.getYOnSurface((class_5281)world, (int)(center.method_10263() + 2), (int)(center.method_10260() + 2))) / 5;
    }

    protected int getAverageYWG(class_5281 world, class_2338 center) {
        int y = DefaultFeature.getYOnSurfaceWG((class_5281)world, (int)center.method_10263(), (int)center.method_10260());
        y += DefaultFeature.getYOnSurfaceWG((class_5281)world, (int)(center.method_10263() - 2), (int)(center.method_10260() - 2));
        y += DefaultFeature.getYOnSurfaceWG((class_5281)world, (int)(center.method_10263() + 2), (int)(center.method_10260() - 2));
        y += DefaultFeature.getYOnSurfaceWG((class_5281)world, (int)(center.method_10263() - 2), (int)(center.method_10260() + 2));
        return (y += DefaultFeature.getYOnSurfaceWG((class_5281)world, (int)(center.method_10263() + 2), (int)(center.method_10260() + 2))) / 5;
    }

    public boolean method_13151(class_5821<FC> context) {
        NBTFeatureConfig cfg = (NBTFeatureConfig)context.method_33656();
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        class_2338 center = context.method_33655();
        center = new class_2338(center.method_10263() >> 4 << 4 | 8, 128, center.method_10260() >> 4 << 4 | 8);
        if (!this.canSpawn(world, center = this.getGround(world, center), random)) {
            return false;
        }
        int posY = center.method_10264() + 1;
        class_3499 structure = this.getStructure(cfg, world, center, random);
        class_2470 rotation = this.getRotation(world, center, random);
        class_2415 mirror = this.getMirror(world, center, random);
        class_2338 offset = class_3499.method_15168((class_2338)new class_2338(structure.method_15160()), (class_2415)mirror, (class_2470)rotation, (class_2338)class_2338.field_10980);
        center = center.method_10069(0, (int)((double)this.getYOffset(structure, world, center, random) + 0.5), 0);
        class_3341 bounds = this.makeBox(center);
        class_3492 placementData = new class_3492().method_15123(rotation).method_15125(mirror).method_15126(bounds);
        this.addStructureData(placementData);
        center = center.method_10069((int)((double)(-offset.method_10263()) * 0.5), 0, (int)((double)(-offset.method_10260()) * 0.5));
        structure.method_15172((class_5425)world, center, center, placementData, random, 4);
        TerrainMerge merge = this.getTerrainMerge(world, center, random);
        int x1 = center.method_10263();
        int z1 = center.method_10260();
        int x2 = x1 + offset.method_10263();
        int z2 = z1 + offset.method_10260();
        if (merge != TerrainMerge.NONE) {
            int a;
            class_2338.class_2339 mut = new class_2338.class_2339();
            if (x2 < x1) {
                a = x1;
                x1 = x2;
                x2 = a;
            }
            if (z2 < z1) {
                a = z1;
                z1 = z2;
                z2 = a;
            }
            int surfMax = posY - 1;
            for (int x = x1; x <= x2; ++x) {
                mut.method_33097(x);
                block1: for (int z = z1; z <= z2; ++z) {
                    mut.method_33099(z);
                    mut.method_33098(surfMax);
                    class_2680 state = world.method_8320((class_2338)mut);
                    if (this.isTerrain(state) || !state.method_26206((class_1922)world, (class_2338)mut, class_2350.field_11033)) continue;
                    for (int i = 0; i < 10; ++i) {
                        mut.method_33098(mut.method_10264() - 1);
                        class_2680 stateSt = world.method_8320((class_2338)mut);
                        if (!this.isTerrain(stateSt)) {
                            if (merge == TerrainMerge.SURFACE) {
                                boolean isTop = mut.method_10264() == surfMax && state.method_51367();
                                class_6880 b = world.method_23753((class_2338)mut);
                                class_2680 top = (isTop ? BiomeAPI.findTopMaterial((class_6880)b) : BiomeAPI.findUnderMaterial((class_6880)b)).orElse(cfg.defaultBlock);
                                BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)top);
                                continue;
                            }
                            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)state);
                            continue;
                        }
                        if (!this.isTerrain(state) || !state.method_51367()) continue block1;
                        if (merge == TerrainMerge.SURFACE) {
                            class_6880 b = world.method_23753((class_2338)mut);
                            class_2680 bottom = BiomeAPI.findUnderMaterial((class_6880)b).orElse(cfg.defaultBlock);
                            BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)bottom);
                            continue block1;
                        }
                        BlocksHelper.setWithoutUpdate((class_1936)world, (class_2338)mut, (class_2680)state);
                        continue block1;
                    }
                }
            }
        }
        return true;
    }

    private boolean isTerrain(class_2680 state) {
        return state.method_26164(CommonBlockTags.END_STONES) || state.method_26164(CommonBlockTags.NETHER_STONES);
    }

    protected class_3341 makeBox(class_2338 pos) {
        int sx = (pos.method_10263() >> 4 << 4) - 16;
        int sz = (pos.method_10260() >> 4 << 4) - 16;
        int ex = sx + 47;
        int ez = sz + 47;
        return class_3341.method_34390((class_2382)new class_2382(sx, 0, sz), (class_2382)new class_2382(ex, 255, ez));
    }

    public static enum TerrainMerge implements class_3542
    {
        NONE,
        SURFACE,
        OBJECT;

        public static final Codec<TerrainMerge> CODEC;

        public static TerrainMerge getFromString(String type) {
            if (type.equals("surface")) {
                return SURFACE;
            }
            if (type.equals("object")) {
                return OBJECT;
            }
            return NONE;
        }

        public String method_15434() {
            return this.name();
        }

        static {
            CODEC = class_3542.method_28140(TerrainMerge::values);
        }
    }
}

