/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5481;
import org.jetbrains.annotations.Nullable;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.compat.emi.AlloyForgeryEmiPlugin;
import wraith.alloyforgery.compat.emi.CustomButtonWidget;
import wraith.alloyforgery.compat.emi.CustomSlotWidget;
import wraith.alloyforgery.compat.emi.CustomTextWidget;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgeryEmiRecipe
implements EmiRecipe {
    static final class_2960 GUI_TEXTURE = AlloyForgery.id("textures/gui/forge_controller.png");
    private final class_2960 id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> outputs;
    private final int minForgeTier;
    private final int requiredFuel;
    private final Map<AlloyForgeRecipe.OverrideRange, EmiStack> overrides;
    private final List<AlloyForgeRecipe.OverrideRange> overridesKeys;
    private int currentIndex = 0;
    private class_5481 currentTierText;
    private EmiStack currentStack;
    private final CustomTextWidget tierTextWidget;
    private final CustomButtonWidget cycleTierWidget;
    private final CustomSlotWidget outputWidget;

    public AlloyForgeryEmiRecipe(AlloyForgeRecipe recipe) {
        this.id = recipe.method_8114();
        ArrayList<EmiIngredient> convertedInputs = new ArrayList<EmiIngredient>();
        for (Map.Entry<class_1856, Integer> entry : recipe.getIngredientsMap().entrySet()) {
            int stackCount;
            for (int i = entry.getValue().intValue(); i > 0; i -= stackCount) {
                stackCount = Math.min(i, 64);
                convertedInputs.add(EmiIngredient.of(Arrays.stream(entry.getKey().method_8105()).map(class_1799::method_7972).peek(stack -> stack.method_7939(stackCount)).map(EmiStack::of).toList()));
            }
        }
        this.inputs = convertedInputs;
        this.minForgeTier = recipe.getMinForgeTier();
        this.requiredFuel = recipe.getFuelPerTick();
        this.currentTierText = class_2561.method_43469((String)"container.alloy_forgery.rei.min_tier", (Object[])new Object[]{this.minForgeTier}).method_30937();
        this.currentStack = EmiStack.of((class_1799)recipe.getOutput());
        this.outputs = List.of(this.currentStack);
        HashMap<AlloyForgeRecipe.OverrideRange, EmiStack> tierOverrides = new HashMap<AlloyForgeRecipe.OverrideRange, EmiStack>();
        for (Map.Entry entry : recipe.getTierOverrides().entrySet()) {
            tierOverrides.put((AlloyForgeRecipe.OverrideRange)entry.getKey(), EmiStack.of((class_1799)((class_1799)entry.getValue())));
        }
        this.overrides = tierOverrides;
        this.overridesKeys = this.overrides.keySet().stream().toList();
        this.tierTextWidget = new CustomTextWidget(this.currentTierText, 8, 7, 0x404040, false);
        this.cycleTierWidget = new CustomButtonWidget(127, 2, () -> !this.overrides.isEmpty(), (mouseX, mouseY, button) -> this.cycleStacks());
        this.outputWidget = new CustomSlotWidget((EmiIngredient)this.currentStack, 104, 38, this);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)this.tierTextWidget);
        widgets.addText(class_2561.method_43469((String)"container.alloy_forgery.rei.fuel_per_tick", (Object[])new Object[]{this.requiredFuel}).method_30937(), 8, 20, 0x404040, false);
        widgets.addTexture(GUI_TEXTURE, 6, 34, 92, 38, 42, 41);
        widgets.addTexture(GUI_TEXTURE, 107, 14, 10, 10, 208, 30);
        widgets.addTexture(GUI_TEXTURE, 111, 17, 16, 20, 176, 0);
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = 7 + i % 5 * 18;
            int y = 35 + i / 5 * 18;
            widgets.addTexture(GUI_TEXTURE, x, y, 18, 18, 208, 0);
            widgets.addSlot(this.inputs.get(i), x, y).drawBack(false);
        }
        widgets.add((Widget)this.cycleTierWidget);
        widgets.add((Widget)this.outputWidget);
    }

    private void cycleStacks() {
        ++this.currentIndex;
        if (this.currentIndex > this.overrides.size()) {
            this.currentIndex = 0;
        }
        if (this.currentIndex == 0) {
            this.currentTierText = class_2561.method_43469((String)"container.alloy_forgery.rei.min_tier", (Object[])new Object[]{this.minForgeTier}).method_30937();
            this.currentStack = this.outputs.get(0);
        } else {
            AlloyForgeRecipe.OverrideRange range = this.overridesKeys.get(this.currentIndex - 1);
            this.currentTierText = class_2561.method_43469((String)"container.alloy_forgery.rei.min_tier", (Object[])new Object[]{range}).method_30937();
            this.currentStack = this.overrides.get(range);
        }
        this.tierTextWidget.setText(this.currentTierText);
        this.outputWidget.setMutableStack((EmiIngredient)this.currentStack);
    }

    public EmiRecipeCategory getCategory() {
        return AlloyForgeryEmiPlugin.FORGE_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 142;
    }

    public int getDisplayHeight() {
        return 78;
    }
}

