/*
 * Decompiled with CFR 0.152.
 */
package dev.thestaticvoid.mi_sound_addon.sound;

import aztech.modern_industrialization.machines.recipe.MachineRecipeType;
import dev.thestaticvoid.mi_sound_addon.MISoundAddonConfig;
import dev.thestaticvoid.mi_sound_addon.sound.ModSoundEventInfo;
import dev.thestaticvoid.mi_sound_addon.sound.ModSounds;
import java.util.List;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class SoundEventRegistry {
    private static final int DEFAULT_SOUND_DURATION = 60;

    public static void populateDefaultRecipeTypes(List<MachineRecipeType> machineRecipeTypes) {
        for (MachineRecipeType mrt : machineRecipeTypes) {
            String type = mrt.getPath();
            if (type.equals("forge_hammer")) continue;
            SoundEventRegistry.addSoundEvent(type);
        }
        SoundEventRegistry.addSoundEvent("electric_blast_furnace");
        SoundEventRegistry.addSoundEvent("fission_reactor");
        SoundEventRegistry.addSoundEvent("wrench");
        SoundEventRegistry.addSoundEvent("replicator");
        SoundEventRegistry.updateDurations();
        SoundEventRegistry.updateVolumes();
    }

    public static void setDuration(String type, int duration) {
        if (!ModSounds.SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set duration of non-existent recipe type: " + type);
        }
        ModSounds.SOUND_EVENTS.get(type).setSoundDuration(duration);
    }

    public static void setVolume(String type, float volume) {
        if (!ModSounds.SOUND_EVENTS.containsKey(type)) {
            throw new IllegalStateException("Tried to set volume of non-existent recipe type: " + type);
        }
        ModSounds.SOUND_EVENTS.get(type).setVolume(volume);
    }

    public static void addSoundEvent(String type) {
        SoundEventRegistry.addSoundEvent(type, 1.0f);
    }

    public static void addSoundEvent(String type, float volume) {
        SoundEventRegistry.addSoundEvent(type, volume, 60);
    }

    public static void addSoundEvent(String type, float volume, int duration) {
        class_2960 identifier = new class_2960("mi_sound_addon", type);
        class_3414 newSoundEvent = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)identifier, (Object)class_3414.method_47908((class_2960)identifier));
        ModSounds.SOUND_EVENTS.put(type, new ModSoundEventInfo(newSoundEvent, duration, volume));
    }

    private static void updateDurations() {
        SoundEventRegistry.setDuration("assembler", 39);
        SoundEventRegistry.setDuration("blast_furnace", 31);
        SoundEventRegistry.setDuration("centrifuge", 39);
        SoundEventRegistry.setDuration("chemical_reactor", 80);
        SoundEventRegistry.setDuration("coke_oven", 33);
        SoundEventRegistry.setDuration("compressor", 30);
        SoundEventRegistry.setDuration("cutting_machine", 68);
        SoundEventRegistry.setDuration("distillation_tower", 110);
        SoundEventRegistry.setDuration("distillery", 71);
        SoundEventRegistry.setDuration("electric_blast_furnace", 61);
        SoundEventRegistry.setDuration("electrolyzer", 7);
        SoundEventRegistry.setDuration("fission_reactor", 60);
        SoundEventRegistry.setDuration("fusion_reactor", 67);
        SoundEventRegistry.setDuration("furnace", 38);
        SoundEventRegistry.setDuration("heat_exchanger", 71);
        SoundEventRegistry.setDuration("implosion_compressor", 70);
        SoundEventRegistry.setDuration("macerator", 16);
        SoundEventRegistry.setDuration("mixer", 27);
        SoundEventRegistry.setDuration("oil_drilling_rig", 33);
        SoundEventRegistry.setDuration("packer", 23);
        SoundEventRegistry.setDuration("polarizer", 35);
        SoundEventRegistry.setDuration("pressurizer", 89);
        SoundEventRegistry.setDuration("quarry", 61);
        SoundEventRegistry.setDuration("unpacker", 23);
        SoundEventRegistry.setDuration("vacuum_freezer", 62);
        SoundEventRegistry.setDuration("wiremill", 45);
        SoundEventRegistry.setDuration("replicator", 20);
    }

    private static void updateVolumes() {
        MISoundAddonConfig config = MISoundAddonConfig.getConfig();
        SoundEventRegistry.setVolume("assembler", config.assemblerVolume);
        SoundEventRegistry.setVolume("blast_furnace", config.blastFurnaceVolume);
        SoundEventRegistry.setVolume("centrifuge", config.centrifugeVolume);
        SoundEventRegistry.setVolume("chemical_reactor", config.chemicalReactorVolume);
        SoundEventRegistry.setVolume("coke_oven", config.cokeOvenVolume);
        SoundEventRegistry.setVolume("compressor", config.compressorVolume);
        SoundEventRegistry.setVolume("cutting_machine", config.cuttingMachineVolume);
        SoundEventRegistry.setVolume("distillation_tower", config.distillationTowerVolume);
        SoundEventRegistry.setVolume("distillery", config.distilleryVolume);
        SoundEventRegistry.setVolume("electric_blast_furnace", config.electricBlastFurnaceVolume);
        SoundEventRegistry.setVolume("electrolyzer", config.electrolyzerVolume);
        SoundEventRegistry.setVolume("fission_reactor", config.fissionReactorVolume);
        SoundEventRegistry.setVolume("fusion_reactor", config.fusionReactorVolume);
        SoundEventRegistry.setVolume("furnace", config.furnaceVolume);
        SoundEventRegistry.setVolume("heat_exchanger", config.heatExchangerVolume);
        SoundEventRegistry.setVolume("implosion_compressor", config.implosionCompressorVolume);
        SoundEventRegistry.setVolume("macerator", config.maceratorVolume);
        SoundEventRegistry.setVolume("mixer", config.mixerVolume);
        SoundEventRegistry.setVolume("oil_drilling_rig", config.oilDrillingRigVolume);
        SoundEventRegistry.setVolume("packer", config.packerVolume);
        SoundEventRegistry.setVolume("polarizer", config.polarizerVolume);
        SoundEventRegistry.setVolume("pressurizer", config.pressurizerVolume);
        SoundEventRegistry.setVolume("quarry", config.quarryVolume);
        SoundEventRegistry.setVolume("unpacker", config.unpackerVolume);
        SoundEventRegistry.setVolume("vacuum_freezer", config.vacuumFreezerVolume);
        SoundEventRegistry.setVolume("wiremill", config.wiremillVolume);
        SoundEventRegistry.setVolume("wrench", config.wrenchVolume);
        SoundEventRegistry.setVolume("replicator", config.replicatorVolume);
    }
}

