/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.Monitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.AddMusicMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.AddOnlinePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.AddPlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.AuthorityMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.CreatePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DeleteMusicMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DeletePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DetailMusicMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.DetailPlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.EditMusicMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.EditPlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportMusicsSelectMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportPlayListSelectMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImportYoutubePlayListMusicsMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.OffMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.SearchMusicMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.TestMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.UploadMusicMMMonitor;
import dev.felnull.imp.client.music.MusicEngine;
import dev.felnull.otyacraftengine.client.util.OERenderUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MusicManagerMonitor
extends Monitor<MusicManagerBlockEntity> {
    private static final Map<MusicManagerBlockEntity.MonitorType, MonitorFactory> monitorFactory = new HashMap<MusicManagerBlockEntity.MonitorType, MonitorFactory>();
    protected static final class_2960 BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/background.png");
    public static final class_2960 WIDGETS_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/widgets.png");
    public static final class_2960 BASE_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/base.png");
    protected boolean header = true;
    private final MusicManagerBlockEntity.MonitorType type;
    private final MusicManagerScreen screen;

    public MusicManagerMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super((class_2561)class_2561.method_43471((String)("imp.monitor.music_manager." + type.getName())), 8, 20, 370, 199);
        this.type = type;
        this.screen = screen;
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        if (this.header && this.getParentType() != null) {
            this.addRenderWidget(new class_344(this.getStartX() + 356, this.getStartY(), 14, 10, 0, 0, 10, WIDGETS_TEXTURE, 256, 256, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.PLAY_LIST), (class_2561)class_2561.method_43471((String)"imp.button.close")));
            this.addRenderWidget(new class_344(this.getStartX() + 342, this.getStartY(), 14, 10, 14, 0, 10, WIDGETS_TEXTURE, 256, 256, n -> {
                this.onBackParent();
                this.insMonitor(this.getParentType());
            }, (class_2561)class_2561.method_43471((String)"imp.button.backScreen")));
        }
    }

    @Override
    public void render(class_332 guiGraphics, float f, int mouseX, int mouseY) {
        super.render(guiGraphics, f, mouseX, mouseY);
        OERenderUtils.drawTexture((class_2960)BG_TEXTURE, (class_4587)guiGraphics.method_51448(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.header) {
            OERenderUtils.drawTexture((class_2960)BASE_TEXTURE, (class_4587)guiGraphics.method_51448(), (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)10.0f, (float)this.width, (float)this.height);
            this.drawSmartText(guiGraphics, this.title, this.getStartX() + 1, this.getStartY() + 1);
        }
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        OERenderUtils.renderTextureSprite((class_2960)BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.001f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        if (this.header) {
            OERenderUtils.renderTextureSprite((class_2960)BASE_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)(monitorHeight - onPxH * 10.0f), (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)(onPxH * 10.0f), (float)0.0f, (float)0.0f, (float)this.width, (float)10.0f, (float)this.width, (float)this.height, (int)i, (int)j);
            if (this.getParentType() != null) {
                OERenderUtils.renderTextureSprite((class_2960)WIDGETS_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)(onPxW * 356.0f), (float)(monitorHeight - onPxH * 10.0f), (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxW * 14.0f), (float)(onPxH * 10.0f), (float)0.0f, (float)0.0f, (float)14.0f, (float)10.0f, (float)256.0f, (float)256.0f, (int)i, (int)j);
                OERenderUtils.renderTextureSprite((class_2960)WIDGETS_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)(onPxW * 342.0f), (float)(monitorHeight - onPxH * 10.0f), (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxW * 14.0f), (float)(onPxH * 10.0f), (float)14.0f, (float)0.0f, (float)14.0f, (float)10.0f, (float)256.0f, (float)256.0f, (int)i, (int)j);
            }
            this.renderSmartTextSprite(poseStack, multiBufferSource, this.title, 1.0f, 2.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        }
    }

    public static void firstInit() {
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.OFF, OffMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.TEST, TestMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.PLAY_LIST, PlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.ADD_PLAY_LIST, AddPlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.ADD_ONLINE_PLAY_LIST, AddOnlinePlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.CREATE_PLAY_LIST, CreatePlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.ADD_MUSIC, AddMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.SEARCH_MUSIC, SearchMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.UPLOAD_MUSIC, UploadMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.IMPORT_YOUTUBE_PLAY_LIST, ImportYoutubePlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.EDIT_PLAY_LIST, EditPlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.EDIT_MUSIC, EditMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.DETAIL_PLAY_LIST, DetailPlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.IMPORT_PLAY_LIST_SELECT, ImportPlayListSelectMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.DETAIL_MUSIC, DetailMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.DELETE_PLAY_LIST, DeletePlayListMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.DELETE_MUSIC, DeleteMusicMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.IMPORT_MUSICS_SELECT, ImportMusicsSelectMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.IMPORT_YOUTUBE_PLAY_LIST_MUSICS, ImportYoutubePlayListMusicsMMMonitor::new);
        MusicManagerMonitor.registerMonitors(MusicManagerBlockEntity.MonitorType.AUTHORITY, AuthorityMMMonitor::new);
    }

    public MusicManagerScreen getScreen() {
        return this.screen;
    }

    public static MusicManagerMonitor createdMusicMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        return monitorFactory.get((Object)type).create(type, screen);
    }

    private static void registerMonitors(MusicManagerBlockEntity.MonitorType type, MonitorFactory factory) {
        monitorFactory.put(type, factory);
    }

    public MusicEngine getMusicEngine() {
        return MusicEngine.getInstance();
    }

    public MusicManagerBlockEntity.MonitorType getType() {
        return this.type;
    }

    protected void insMonitor(@NotNull MusicManagerBlockEntity.MonitorType type) {
        this.screen.insMonitor(type);
    }

    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return null;
    }

    public void onUpdateSelectedPlayList(UUID playListId) {
    }

    protected void onBackParent() {
    }

    private static interface MonitorFactory {
        public MusicManagerMonitor create(MusicManagerBlockEntity.MonitorType var1, MusicManagerScreen var2);
    }
}

