/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loader;

import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.client.music.loader.MusicLoader;
import dev.felnull.imp.client.music.player.LavaMusicPlayer;
import dev.felnull.imp.client.music.player.MusicPlayer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class LavaMusicLoader
implements MusicLoader {
    private MusicSource musicSource;
    private AudioTrack audioTrack;

    @Override
    @NotNull
    public MusicPlayer<?, ?> createMusicPlayer(UUID musicPlayerId) {
        return new LavaMusicPlayer(musicPlayerId, this.audioTrack, this.musicSource);
    }

    @Override
    public void tryLoad(@NotNull MusicSource source) throws Exception {
        if (!this.isSupportMedia(source)) {
            throw new RuntimeException("Unsupported media");
        }
        LavaPlayerManager lm = LavaPlayerManager.getInstance();
        String wr = this.wrappedIdentifier(source);
        if (wr == null) {
            throw new RuntimeException("Failed to get wrapped identifier");
        }
        Optional<AudioTrack> track = lm.loadTrack(wr);
        if (track.isEmpty()) {
            throw new RuntimeException("Failed to load track");
        }
        if (source.isLive() != track.get().getInfo().isStream) {
            throw new RuntimeException("Discrepancies in live information");
        }
        this.audioTrack = track.get();
        this.musicSource = source;
    }

    protected boolean isSupportMedia(MusicSource source) {
        if (source.isLive() && source.getLoaderType().isEmpty()) {
            return true;
        }
        LavaPlayerManager lm = LavaPlayerManager.getInstance();
        return lm.getMedias().containsKey(source.getLoaderType());
    }

    protected String wrappedIdentifier(MusicSource source) throws Exception {
        return source.getIdentifier();
    }

    @Override
    public int priority() {
        return 0;
    }
}

