/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpegts;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerDetectionResult;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerHints;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.MediaContainerProbe;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.adts.AdtsStreamReader;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpegts.MpegAdtsAudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpegts.MpegTsElementaryInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.mpegts.PesPacketInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SavedHeadSeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.SeekableInputStream;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioReference;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.info.AudioTrackInfoBuilder;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;

public class MpegAdtsContainerProbe
implements MediaContainerProbe {
    private static final Logger log = LoggerFactory.getLogger(MpegAdtsContainerProbe.class);

    @Override
    public String getName() {
        return "mpegts-adts";
    }

    @Override
    public boolean matchesHints(MediaContainerHints hints) {
        return "ts".equalsIgnoreCase(hints.fileExtension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaContainerDetectionResult probe(AudioReference reference, SeekableInputStream inputStream) throws IOException {
        SavedHeadSeekableInputStream head;
        SavedHeadSeekableInputStream savedHeadSeekableInputStream = head = inputStream instanceof SavedHeadSeekableInputStream ? (SavedHeadSeekableInputStream)inputStream : null;
        if (head != null) {
            head.setAllowDirectReads(false);
        }
        MpegTsElementaryInputStream tsStream = new MpegTsElementaryInputStream(inputStream, 15);
        PesPacketInputStream pesStream = new PesPacketInputStream(tsStream);
        AdtsStreamReader reader = new AdtsStreamReader(pesStream);
        try {
            if (reader.findPacketHeader() != null) {
                log.debug("Track {} is an MPEG-TS stream with an ADTS track.", (Object)reference.identifier);
                MediaContainerDetectionResult mediaContainerDetectionResult = MediaContainerDetectionResult.supportedFormat(this, null, AudioTrackInfoBuilder.create(reference, inputStream).apply(tsStream.getLoadedMetadata()).build());
                return mediaContainerDetectionResult;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            if (head != null) {
                head.setAllowDirectReads(true);
            }
        }
        return null;
    }

    @Override
    public AudioTrack createTrack(String parameters, AudioTrackInfo trackInfo, SeekableInputStream inputStream) {
        return new MpegAdtsAudioTrack(trackInfo, inputStream);
    }
}

