/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.playlists;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.container.playlists.ExtendedM3uParser;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.source.stream.M3uStreamSegmentUrlProvider;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpGet;
import dev.felnull.imp.include.org.apache.http.client.methods.HttpUriRequest;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.List;

public class HlsStreamSegmentUrlProvider
extends M3uStreamSegmentUrlProvider {
    private static final Logger log = LoggerFactory.getLogger(HlsStreamSegmentUrlProvider.class);
    private final String streamListUrl;
    private volatile String segmentPlaylistUrl;

    public HlsStreamSegmentUrlProvider(String streamListUrl, String segmentPlaylistUrl) {
        this.streamListUrl = streamListUrl;
        this.segmentPlaylistUrl = segmentPlaylistUrl;
    }

    @Override
    protected String getQualityFromM3uDirective(ExtendedM3uParser.Line directiveLine) {
        return "default";
    }

    @Override
    protected String fetchSegmentPlaylistUrl(HttpInterface httpInterface) throws IOException {
        if (this.segmentPlaylistUrl != null) {
            return this.segmentPlaylistUrl;
        }
        HttpGet request = new HttpGet(this.streamListUrl);
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = this.loadChannelStreamsList(HttpClientTools.fetchResponseLines(httpInterface, request, "HLS stream list"));
        if (streams.isEmpty()) {
            throw new IllegalStateException("No streams listed in HLS stream list.");
        }
        M3uStreamSegmentUrlProvider.ChannelStreamInfo stream = streams.get(0);
        log.debug("Chose stream with url {}", (Object)stream.quality, (Object)stream.url);
        this.segmentPlaylistUrl = stream.url;
        return this.segmentPlaylistUrl;
    }

    @Override
    protected HttpUriRequest createSegmentGetRequest(String url) {
        return new HttpGet(url);
    }

    public static String findHlsEntryUrl(String[] lines) {
        List<M3uStreamSegmentUrlProvider.ChannelStreamInfo> streams = new HlsStreamSegmentUrlProvider(null, null).loadChannelStreamsList(lines);
        return streams.isEmpty() ? null : streams.get((int)0).url;
    }
}

