/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote;

import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.remote.RemoteNodeManager;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.ExceptionTools;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.AudioTrackState;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarkerHandler;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackMarkerTracker;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.TrackStateListener;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioFrameBuffer;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.AudioTrackExecutor;
import dev.felnull.imp.include.com.sedmelluq.discord.lavaplayer.track.playback.MutableAudioFrame;
import dev.felnull.imp.include.org.slf4j.Logger;
import dev.felnull.imp.include.org.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class RemoteAudioTrackExecutor
implements AudioTrackExecutor {
    private static final Logger log = LoggerFactory.getLogger(RemoteAudioTrackExecutor.class);
    private static final long NO_SEEK = -1L;
    private static final int BUFFER_DURATION_MS = 3000;
    private final AudioTrack track;
    private final AudioConfiguration configuration;
    private final RemoteNodeManager remoteNodeManager;
    private final AtomicInteger volumeLevel;
    private final long executorId;
    private final AudioFrameBuffer frameBuffer;
    private final AtomicLong lastFrameTimecode = new AtomicLong();
    private final AtomicLong pendingSeek = new AtomicLong(-1L);
    private final TrackMarkerTracker markerTracker = new TrackMarkerTracker();
    private volatile TrackStateListener activeListener;
    private volatile boolean hasReceivedData;
    private volatile boolean hasStarted;
    private volatile Throwable trackException;

    public RemoteAudioTrackExecutor(AudioTrack track, AudioConfiguration configuration, RemoteNodeManager remoteNodeManager, AtomicInteger volumeLevel) {
        this.track = track;
        this.configuration = configuration.copy();
        this.remoteNodeManager = remoteNodeManager;
        this.volumeLevel = volumeLevel;
        this.executorId = System.nanoTime();
        this.frameBuffer = configuration.getFrameBufferFactory().create(3000, configuration.getOutputFormat(), null);
    }

    public long getExecutorId() {
        return this.executorId;
    }

    public AudioConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getVolume() {
        return this.volumeLevel.get();
    }

    public AudioTrack getTrack() {
        return this.track;
    }

    public long getPendingSeek() {
        return this.pendingSeek.get();
    }

    public void clearSeek(long position) {
        if (position != -1L) {
            this.frameBuffer.setClearOnInsert();
            if (this.pendingSeek.compareAndSet(position, -1L)) {
                this.markerTracker.checkSeekTimecode(position);
            }
        }
    }

    public void dispatchException(FriendlyException exception) {
        TrackStateListener currentListener = this.activeListener;
        ExceptionTools.log(log, exception, this.track.getIdentifier());
        if (currentListener != null) {
            this.trackException = exception;
            currentListener.onTrackException(this.track, exception);
        }
    }

    public void receivedData() {
        this.hasReceivedData = true;
    }

    public void detach() {
        this.activeListener = null;
        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.ENDED);
    }

    @Override
    public AudioFrameBuffer getAudioBuffer() {
        return this.frameBuffer;
    }

    @Override
    public void execute(TrackStateListener listener) {
        try {
            this.hasStarted = true;
            this.activeListener = listener;
            this.remoteNodeManager.startPlaying(this);
        }
        catch (Throwable throwable) {
            listener.onTrackException(this.track, ExceptionTools.wrapUnfriendlyExceptions("An error occurred when trying to start track remotely.", FriendlyException.Severity.FAULT, throwable));
            ExceptionTools.rethrowErrors(throwable);
        }
    }

    @Override
    public void stop() {
        this.frameBuffer.lockBuffer();
        this.frameBuffer.setTerminateOnEmpty();
        this.frameBuffer.clear();
        this.markerTracker.trigger(TrackMarkerHandler.MarkerState.STOPPED);
        this.remoteNodeManager.onTrackEnd(null, this.track, AudioTrackEndReason.STOPPED);
    }

    @Override
    public long getPosition() {
        return this.lastFrameTimecode.get();
    }

    @Override
    public void setPosition(long timecode) {
        this.pendingSeek.set(timecode);
    }

    @Override
    public AudioTrackState getState() {
        if (this.hasStarted && this.activeListener == null) {
            return AudioTrackState.FINISHED;
        }
        if (!this.hasReceivedData) {
            return AudioTrackState.LOADING;
        }
        return AudioTrackState.PLAYING;
    }

    @Override
    public void setMarker(TrackMarker marker) {
        this.markerTracker.set(marker, this.getPosition());
    }

    @Override
    public AudioFrame provide() {
        AudioFrame frame = this.frameBuffer.provide();
        this.processProvidedFrame(frame);
        return frame;
    }

    @Override
    public AudioFrame provide(long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        AudioFrame frame = this.frameBuffer.provide(timeout, unit);
        this.processProvidedFrame(frame);
        return frame;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame) {
        if (this.frameBuffer.provide(targetFrame)) {
            this.processProvidedFrame(targetFrame);
            return true;
        }
        return true;
    }

    @Override
    public boolean provide(MutableAudioFrame targetFrame, long timeout, TimeUnit unit) throws TimeoutException, InterruptedException {
        if (this.frameBuffer.provide(targetFrame, timeout, unit)) {
            this.processProvidedFrame(targetFrame);
            return true;
        }
        return true;
    }

    private void processProvidedFrame(AudioFrame frame) {
        if (frame != null && !frame.isTerminator()) {
            this.lastFrameTimecode.set(frame.getTimecode());
            if (this.pendingSeek.get() == -1L && !this.frameBuffer.hasClearOnInsert()) {
                this.markerTracker.checkPlaybackTimecode(frame.getTimecode());
            }
        }
    }

    @Override
    public boolean failedBeforeLoad() {
        return this.trackException != null && !this.hasReceivedData;
    }

    public long getNextInputTimecode() {
        Long lastBufferTimecode;
        boolean dataReceived = this.hasReceivedData;
        long frameDuration = this.configuration.getOutputFormat().frameDuration();
        if (dataReceived && (lastBufferTimecode = this.frameBuffer.getLastInputTimecode()) != null) {
            return lastBufferTimecode + frameDuration;
        }
        long seekPosition = this.pendingSeek.get();
        if (seekPosition != -1L) {
            return seekPosition;
        }
        return dataReceived ? this.lastFrameTimecode.get() + frameDuration : this.lastFrameTimecode.get();
    }

    public String toString() {
        return "RemoteExec " + this.executorId + ", " + this.track.getIdentifier();
    }
}

