/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class AuthorityInfo
implements TagSerializable {
    private boolean publiced;
    private UUID owner;
    private String ownerName;
    private Map<UUID, AuthorityType> authority = new HashMap<UUID, AuthorityType>();
    private AuthorityType initialAuthority;

    public AuthorityInfo() {
    }

    public AuthorityInfo(boolean publiced, UUID owner, String ownerName, AuthorityType initialAuthority) {
        this(publiced, owner, ownerName, new HashMap<UUID, AuthorityType>(), initialAuthority);
    }

    public AuthorityInfo(boolean publiced, UUID owner, String ownerName, Map<UUID, AuthorityType> authority, AuthorityType initialAuthority) {
        this.publiced = publiced;
        this.owner = owner;
        this.authority = authority;
        this.ownerName = ownerName;
        this.initialAuthority = initialAuthority;
    }

    public void save(class_2487 tag) {
        tag.method_10556("Public", this.publiced);
        tag.method_25927("Owner", this.owner);
        IMPNbtUtil.writeAuthority(tag, "Authority", this.authority);
        tag.method_10582("OwnerName", this.ownerName);
        tag.method_10582("InitialAuthority", this.initialAuthority.getName());
    }

    public void load(class_2487 tag) {
        this.publiced = tag.method_10577("Public");
        this.owner = tag.method_25926("Owner");
        IMPNbtUtil.readAuthority(tag, "Authority", this.authority);
        this.ownerName = tag.method_10558("OwnerName");
        this.initialAuthority = AuthorityType.getByName(tag.method_10558("InitialAuthority"));
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean isPublic() {
        return this.publiced;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public Map<UUID, AuthorityType> getRawAuthority() {
        return this.authority;
    }

    @NotNull
    public AuthorityType getAuthorityType(@NotNull UUID playerId) {
        if (this.owner.equals(playerId)) {
            return AuthorityType.OWNER;
        }
        AuthorityType au = this.authority.get(playerId);
        return au == null ? this.getDefaultAuthority() : au;
    }

    public AuthorityType getDefaultAuthority() {
        return this.isPublic() ? AuthorityType.NONE : AuthorityType.BAN;
    }

    @NotNull
    public Map<UUID, AuthorityType> getPlayersAuthority() {
        HashMap<UUID, AuthorityType> na = new HashMap<UUID, AuthorityType>(this.authority);
        na.put(this.owner, AuthorityType.OWNER);
        return Collections.unmodifiableMap(na);
    }

    public boolean canJoin(UUID playerId) {
        AuthorityType type = this.getAuthorityType(playerId);
        return !type.isBan() && this.publiced || type.isInvitation() && !this.publiced;
    }

    public AuthorityType getInitialAuthority() {
        return this.initialAuthority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorityInfo that = (AuthorityInfo)o;
        return this.publiced == that.publiced && Objects.equals(this.owner, that.owner) && Objects.equals(this.ownerName, that.ownerName) && Objects.equals(this.authority, that.authority) && this.initialAuthority == that.initialAuthority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.publiced, this.owner, this.ownerName, this.authority, this.initialAuthority});
    }

    public String toString() {
        return "AuthorityInfo{publiced=" + this.publiced + ", owner=" + this.owner + ", ownerName='" + this.ownerName + "', authority=" + this.authority + ", initialAuthority=" + this.initialAuthority + "}";
    }

    public static enum AuthorityType {
        OWNER("owner", 4),
        ADMIN("admin", 3),
        MEMBER("member", 2),
        READ_ONLY("read_only", 1),
        INVITATION("invitation", 0),
        BAN("ban", 0),
        NONE("none", 0);

        private final String name;
        private final class_2561 text;
        private final int level;

        private AuthorityType(String name, int level) {
            this.name = name;
            this.text = class_2561.method_43471((String)("imp.text.authority." + name));
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getText() {
            return this.text;
        }

        public boolean isMoreOwner() {
            return this.level >= 4;
        }

        public boolean isMoreAdmin() {
            return this.level >= 3;
        }

        public boolean isMoreMember() {
            return this.level >= 2;
        }

        public boolean isMoreReadOnly() {
            return this.level >= 1;
        }

        public boolean isBan() {
            return this == BAN;
        }

        public boolean isInvitation() {
            return this == INVITATION;
        }

        public static AuthorityType getByName(String name) {
            for (AuthorityType type : AuthorityType.values()) {
                if (!type.getName().equals(name)) continue;
                return type;
            }
            return NONE;
        }

        public boolean canEdit() {
            return this.isMoreAdmin();
        }

        public boolean canMusicDelete() {
            return this.isMoreAdmin();
        }

        public boolean canDelete() {
            return this == OWNER;
        }

        public boolean canAddMusic() {
            return this.isMoreMember();
        }

        public boolean canChangeAuth(AuthorityType targetAuth) {
            return this.isMoreAdmin() && this.getLevel() > targetAuth.getLevel();
        }
    }
}

