/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.music.resource;

import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.IIMPComparable;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.otyacraftengine.server.level.TagSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class MusicPlayList
implements TagSerializable,
IIMPComparable {
    private UUID uuid;
    private String name;
    private ImageInfo image;
    private AuthorityInfo authority;
    private List<UUID> musicList = new ArrayList<UUID>();
    private long createDate;

    public MusicPlayList() {
    }

    public MusicPlayList(UUID uuid, String name, ImageInfo image, AuthorityInfo authority, List<UUID> musicList, long createDate) {
        this.uuid = uuid;
        this.name = name;
        this.image = image;
        this.authority = authority;
        this.musicList = musicList;
        this.createDate = createDate;
    }

    public void save(class_2487 tag) {
        tag.method_25927("UUID", this.uuid);
        tag.method_10582("Name", this.name);
        tag.method_10566("Image", (class_2520)this.image.createSavedTag());
        tag.method_10566("Authority", (class_2520)this.authority.createSavedTag());
        OENbtUtils.writeUUIDList((class_2487)tag, (String)"MusicList", this.musicList);
        tag.method_10544("CreateDate", this.createDate);
    }

    public void load(class_2487 tag) {
        this.uuid = tag.method_25926("UUID");
        this.name = tag.method_10558("Name");
        this.image = (ImageInfo)TagSerializable.loadSavedTag((class_2487)tag.method_10562("Image"), (TagSerializable)new ImageInfo());
        this.authority = (AuthorityInfo)TagSerializable.loadSavedTag((class_2487)tag.method_10562("Authority"), (TagSerializable)new AuthorityInfo());
        OENbtUtils.readUUIDList((class_2487)tag, (String)"MusicList", this.musicList);
        this.createDate = tag.method_10537("CreateDate");
    }

    public String getName() {
        return this.name;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public AuthorityInfo getAuthority() {
        return this.authority;
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public List<UUID> getMusicList() {
        return this.musicList;
    }

    public long getCreateDate() {
        return this.createDate;
    }

    public int getPlayerCount() {
        return (int)this.authority.getPlayersAuthority().values().stream().filter(AuthorityInfo.AuthorityType::isMoreReadOnly).count();
    }

    public String toString() {
        return "MusicPlayList{uuid=" + this.uuid + ", name='" + this.name + "', image=" + this.image + ", authority=" + this.authority + ", musicList=" + this.musicList + ", createDate=" + this.createDate + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MusicPlayList that = (MusicPlayList)o;
        return this.createDate == that.createDate && Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name) && Objects.equals(this.image, that.image) && Objects.equals(this.authority, that.authority) && Objects.equals(this.musicList, that.musicList);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.name, this.image, this.authority, this.musicList, this.createDate);
    }

    @Override
    public String getCompareName() {
        return this.name;
    }

    @Override
    public String getComparePlayerName() {
        return this.authority.getOwner().toString();
    }

    @Override
    public long getCompareDate() {
        return this.createDate;
    }
}

