/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.handler;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.GameInstance;
import dev.felnull.imp.block.BoomboxData;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.item.BoomboxItem;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerMessageHandler {
    public static void onHandLidCycleMessage(IMPPackets.LidCycleMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_1799 item = message.itemLocation.getItem(packetContext.getPlayer());
            if (item.method_7909() instanceof BoomboxItem) {
                UUID id = BoomboxItem.getRingerUUID(item);
                if (id == null || !id.equals(message.boomboxId)) {
                    return;
                }
                BoomboxData data = BoomboxItem.getData(item);
                data.cycleLidOpen(packetContext.getPlayer().method_37908());
                BoomboxItem.setData(item, data);
            }
        });
    }

    public static void onMusicPlayListChangeAuthority(IMPPackets.MusicPlayListChangeAuthorityMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                MusicManager.getInstance().changeAuthority(packetContext.getPlayer().method_5682(), message.playlist, message.player, message.authorityType, player);
            }
        });
    }

    public static void onMultipleMusicAdd(IMPPackets.MultipleMusicAddMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                MusicManager.getInstance().addMultipleMusic(packetContext.getPlayer().method_5682(), message.playlist, message.musics, player);
            }
        });
    }

    public static void onMusicOrPlayListDeleteMessage(IMPPackets.MusicOrPlayListDeleteMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                MusicManager mm = MusicManager.getInstance();
                if (message.music) {
                    mm.deleteMusic(packetContext.getPlayer().method_5682(), message.playListID, message.musicID, player);
                } else {
                    mm.deletePlayList(packetContext.getPlayer().method_5682(), message.playListID, player);
                }
            }
        });
    }

    public static void onMusicUpdateResultMessage(IMPPackets.MusicRingUpdateResultMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> MusicRingManager.getInstance().onUpdate((class_3222)packetContext.getPlayer(), message.uuid(), message.waitId(), message.ringResponseStateType()));
    }

    public static void onMusicReadyResultMessage(IMPPackets.MusicRingReadyResultMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> MusicRingManager.getInstance().addReadyPlayer((class_3222)packetContext.getPlayer(), message.uuid, message.waitID, message.result, message.retry, message.elapsed));
    }

    public static void onMusicAddMessage(IMPPackets.MusicMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            MusicManager mm = MusicManager.getInstance();
            MusicPlayList pl = mm.getSaveData(packetContext.getPlayer().method_5682()).getPlayLists().get(message.playlist);
            if (pl != null && pl.getAuthority().getAuthorityType(packetContext.getPlayer().method_7334().getId()).canAddMusic()) {
                Music m = new Music(UUID.randomUUID(), message.name, message.author, message.source, message.image, packetContext.getPlayer().method_7334().getId(), System.currentTimeMillis());
                mm.addMusicToPlayList((class_3222)packetContext.getPlayer(), pl.getUuid(), m);
            }
        });
    }

    public static void onMusicEditMessage(IMPPackets.MusicMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                MusicManager.getInstance().editMusic(packetContext.getPlayer().method_5682(), message.uuid, message.playlist, message.name, message.image, player);
            }
        });
    }

    public static void onMusicPlayListEditMessage(IMPPackets.MusicPlayListMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                MusicManager.getInstance().editPlayList(packetContext.getPlayer().method_5682(), message.uuid, message.name, message.image, message.invitePlayers, message.publiced, message.initMember, player);
            }
        });
    }

    public static void onMusicPlayListAddMessage(IMPPackets.MusicPlayListMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            class_3222 player = (class_3222)packetContext.getPlayer();
            if (message.blockEntityExistence.check(player.method_37908())) {
                HashMap<UUID, AuthorityInfo.AuthorityType> authTypes = new HashMap<UUID, AuthorityInfo.AuthorityType>();
                message.invitePlayers.forEach(n -> authTypes.put((UUID)n, AuthorityInfo.AuthorityType.INVITATION));
                AuthorityInfo auth = new AuthorityInfo(message.publiced, packetContext.getPlayer().method_7334().getId(), packetContext.getPlayer().method_7334().getName(), authTypes, message.initMember ? AuthorityInfo.AuthorityType.MEMBER : AuthorityInfo.AuthorityType.READ_ONLY);
                MusicPlayList pl = new MusicPlayList(UUID.randomUUID(), message.name, message.image, auth, new ArrayList<UUID>(), System.currentTimeMillis());
                MusicManager mm = MusicManager.getInstance();
                mm.addPlayList(packetContext.getPlayer().method_5682(), pl);
                mm.addPlayListToPlayer(packetContext.getPlayer().method_5682(), pl.getUuid(), (class_3222)packetContext.getPlayer());
                for (Music importMusic : message.importMusics) {
                    Music music = new Music(UUID.randomUUID(), importMusic.getName(), importMusic.getAuthor(), importMusic.getSource(), importMusic.getImage(), player.method_7334().getId(), System.currentTimeMillis());
                    mm.addMusicToPlayList(player, pl.getUuid(), music);
                }
                MusicManagerBlockEntity be = (MusicManagerBlockEntity)((class_3222)packetContext.getPlayer()).method_37908().method_8321(message.blockEntityExistence.blockPos());
                if (be != null) {
                    be.setSelectedPlayList((class_3222)packetContext.getPlayer(), pl.getUuid());
                }
            }
        });
    }

    public static void onMusicSyncRequestMessage(IMPPackets.MusicSyncRequestMessage message, NetworkManager.PacketContext packetContext) {
        packetContext.queue(() -> {
            MusicManager mm = MusicManager.getInstance();
            class_3222 pl = (class_3222)packetContext.getPlayer();
            switch (message.syncType) {
                case PLAYLIST_MY_LIST: {
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, mm.getPlayerPlayLists(pl, MusicManager.PlayListGetType.JOIN), new ArrayList<Music>());
                    break;
                }
                case PLAYLIST_CAN_JOIN: {
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, mm.getPlayerPlayLists(pl, MusicManager.PlayListGetType.NO_JOIN), new ArrayList<Music>());
                    break;
                }
                case MUSIC_BY_PLAYLIST: {
                    MusicPlayList mpl = mm.getSaveData(packetContext.getPlayer().method_5682()).getPlayLists().get(message.syncId);
                    if (mpl == null || !mpl.getAuthority().getAuthorityType(pl.method_7334().getId()).isMoreReadOnly()) break;
                    ArrayList<Music> musics = new ArrayList<Music>();
                    mpl.getMusicList().forEach(n -> {
                        Music music = mm.getSaveData(packetContext.getPlayer().method_5682()).getMusics().get(n);
                        if (music != null) {
                            musics.add(music);
                        }
                    });
                    ServerMessageHandler.sendMusicSyncData(pl, message.syncType, message.syncId, new ArrayList<MusicPlayList>(), musics);
                }
            }
        });
    }

    public static void onMusicDataUpdate() {
        if (GameInstance.getServer() != null) {
            GameInstance.getServer().method_3760().method_14571().forEach(n -> ServerMessageHandler.sendMusicSyncData(n, IMPPackets.MusicSyncType.UPDATE, n.method_7334().getId(), new ArrayList<MusicPlayList>(), new ArrayList<Music>()));
        }
    }

    private static void sendMusicSyncData(class_3222 player, IMPPackets.MusicSyncType syncType, UUID uuid, List<MusicPlayList> playLists, List<Music> musics) {
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)IMPPackets.MUSIC_SYNC, (class_2540)new IMPPackets.MusicSyncResponseMessage(syncType, uuid, playLists, musics).toFBB());
    }
}

