/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.networking.IMPPackets;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRing;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicRingManager {
    private static final MusicRingManager INSTANCE = new MusicRingManager();
    private final Map<class_3218, MusicRing> musicRings = new HashMap<class_3218, MusicRing>();

    public static MusicRingManager getInstance() {
        return INSTANCE;
    }

    public void tick(class_3218 level) {
        this.getMusicRing(level).tick();
    }

    public Map<class_3218, MusicRing> getMusicRingers() {
        return this.musicRings;
    }

    public void restartRinger(class_3218 level, UUID uuid) {
        this.getMusicRing(level).restart(uuid);
    }

    public void addRinger(class_3218 level, IMusicRinger ringer) {
        this.getMusicRing(level).addRinger(ringer);
    }

    public boolean isWaitRinger(UUID uuid, class_3218 level) {
        return this.getMusicRing(level).isWaitRinger(uuid);
    }

    public void onUpdate(class_3222 player, UUID uuid, UUID waitUUID, IMPPackets.MusicRingResponseStateType state) {
        this.getMusicRing(player.method_51469()).onUpdate(player, uuid, waitUUID, state);
    }

    public void addReadyPlayer(class_3222 player, UUID uuid, UUID waitUUID, boolean result, boolean retry, long elapsed) {
        this.getMusicRing(player.method_51469()).addReadyPlayer(player, uuid, waitUUID, result, retry, elapsed);
    }

    @NotNull
    public MusicRing getMusicRing(class_3218 level) {
        return this.musicRings.computeIfAbsent(level, MusicRing::new);
    }

    public boolean hasRinger(UUID uuid) {
        for (class_3218 serverLevel : this.musicRings.keySet()) {
            if (!this.hasRinger(serverLevel, uuid)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRinger(class_3218 level, UUID uuid) {
        return this.getMusicRing(level).hasRinger(uuid);
    }

    public IMusicRinger getRinger(UUID uuid) {
        for (Map.Entry<class_3218, MusicRing> entry : this.musicRings.entrySet()) {
            MusicRing mr = entry.getValue();
            IMusicRinger r = mr.getRingers().get(uuid);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    @Nullable
    public class_3218 getLevel(MusicRing ring) {
        for (Map.Entry<class_3218, MusicRing> entry : this.musicRings.entrySet()) {
            if (entry.getValue() != ring) continue;
            return entry.getKey();
        }
        return null;
    }

    public void pause() {
        this.musicRings.forEach((n, m) -> m.pause());
    }

    public void resume() {
        this.musicRings.forEach((n, m) -> m.resume());
    }

    public void clear() {
        this.musicRings.forEach((n, m) -> m.depose());
        this.musicRings.clear();
    }
}

