/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.mehvahdjukaar.moonlight.api.integration.cloth_config.ClothConfigCompat;
import net.mehvahdjukaar.moonlight.api.integration.yacl.YACLCompat;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.ConfigType;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3244;
import net.minecraft.class_437;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.ApiStatus;

public final class FabricConfigSpec
extends ConfigSpec {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final class_2960 res;
    private final ConfigSubCategory mainEntry;
    private final File file = this.getFullPath().toFile();
    private boolean initialized = false;

    @ApiStatus.Internal
    public static void loadAllConfigs() {
        for (Map.Entry c : CONFIG_STORAGE.entrySet()) {
            for (ConfigSpec m : ((Map)c.getValue()).values()) {
                if (m.isLoaded()) continue;
                try {
                    m.loadFromFile();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to load config from mod:" + (String)c.getKey(), e);
                }
            }
        }
    }

    public FabricConfigSpec(class_2960 name, ConfigSubCategory mainEntry, ConfigType type, boolean synced, Runnable changeCallback) {
        super(name.method_12836(), name.method_12836() + "-" + name.method_12832() + ".json", FabricLoader.getInstance().getConfigDir(), type, synced, changeCallback);
        this.mainEntry = mainEntry;
        this.res = name;
        if (this.isSynced()) {
            ServerPlayConnectionEvents.JOIN.register(this::onPlayerLoggedIn);
        }
    }

    public ConfigSubCategory getMainEntry() {
        return this.mainEntry;
    }

    @Override
    public boolean isLoaded() {
        return this.initialized;
    }

    @Override
    public void register() {
        FabricConfigSpec.addTrackedSpec(this);
    }

    @Override
    public void loadFromFile() {
        JsonElement config = null;
        if (this.file.exists() && this.file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(this.file);
                 InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
            }
            catch (IOException e2) {
                throw new RuntimeException("Failed to load config", e2);
            }
        }
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
        if (!this.initialized) {
            this.initialized = true;
            this.saveConfig();
            Moonlight.LOGGER.info("Loaded config {}", (Object)this.getFileName());
        }
    }

    public void saveConfig() {
        try (FileOutputStream stream = new FileOutputStream(this.file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);){
            JsonObject jo = new JsonObject();
            jo.addProperty("#README", "This config file does not support comments. To see them configure it in-game using YACL or Cloth Config");
            this.mainEntry.getEntries().forEach(e -> e.saveToJson(jo));
            GSON.toJson((JsonElement)jo, (Appendable)writer);
        }
        catch (IOException e2) {
            Moonlight.LOGGER.error("Failed to save config {}:", (Object)this.getName(), (Object)e2);
        }
        this.onRefresh();
    }

    @Override
    public class_2561 getName() {
        return class_2561.method_43470((String)LangBuilder.getReadableName(this.res.method_12832() + "_configs"));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_437 makeScreen(class_437 parent, class_2960 background) {
        if (CompatHandler.CLOTH_CONFIG) {
            return ClothConfigCompat.makeScreen(parent, this, background);
        }
        if (CompatHandler.YACL) {
            return YACLCompat.makeScreen(parent, this, background);
        }
        return null;
    }

    @Override
    public boolean hasConfigScreen() {
        return CompatHandler.CLOTH_CONFIG || CompatHandler.YACL;
    }

    @Override
    public void loadFromBytes(InputStream stream) {
        InputStreamReader inputStreamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        JsonElement config = (JsonElement)GSON.fromJson((Reader)bufferedReader, JsonElement.class);
        if (config instanceof JsonObject) {
            JsonObject jo = (JsonObject)config;
            this.mainEntry.getEntries().forEach(e -> e.loadFromJson(jo));
        }
        this.onRefresh();
    }

    private void onPlayerLoggedIn(class_3244 listener, PacketSender sender, MinecraftServer minecraftServer) {
        this.syncConfigsToPlayer(listener.field_14140);
    }
}

