/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.network.fabric;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.ChannelHandler;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkDir;
import net.mehvahdjukaar.moonlight.api.platform.network.fabric.FabricClientNetwork;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class ChannelHandlerImpl
extends ChannelHandler {
    private static final Map<Class<?>, class_2960> ID_MAP = new HashMap();
    private int id = 0;

    public static ChannelHandler createChannel(class_2960 channelMame, int version) {
        return new ChannelHandlerImpl(channelMame);
    }

    public ChannelHandlerImpl(class_2960 channelName) {
        super(channelName);
    }

    @Override
    public <M extends Message> void register(NetworkDir direction, Class<M> messageClass, Function<class_2540, M> decoder) {
        if (direction == NetworkDir.BOTH) {
            this.register(NetworkDir.PLAY_TO_CLIENT, messageClass, decoder);
            direction = NetworkDir.PLAY_TO_SERVER;
        }
        class_2960 res = new class_2960(this.channelName.method_12836(), String.valueOf(this.id++));
        ID_MAP.put(messageClass, res);
        if (direction == NetworkDir.PLAY_TO_SERVER) {
            NetworkDir finalDirection = direction;
            ServerPlayNetworking.registerGlobalReceiver((class_2960)res, (server, player, h, buf, r) -> {
                Message message = (Message)decoder.apply(buf);
                server.execute(() -> message.handle(new Wrapper((class_1657)player, finalDirection)));
            });
        } else if (PlatHelper.getPhysicalSide().isClient()) {
            FabricClientNetwork.register(res, decoder);
        }
    }

    @Override
    public void sendToClientPlayer(class_3222 serverPlayer, Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    @Override
    public void sendToAllClientPlayers(Message message) {
        for (class_3222 p : PlatHelper.getCurrentServer().method_3760().method_14571()) {
            this.sendToClientPlayer(p, message);
        }
    }

    @Override
    public void sendToServer(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        ClientPlayNetworking.send((class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    @Override
    public void sendToAllClientPlayersInRange(class_1937 level, class_2338 pos, double radius, Message message) {
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (currentServer != null) {
            class_3324 players = currentServer.method_3760();
            class_5321 dimension = level.method_27983();
            players.method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), radius, dimension, this.toVanillaPacket(message));
        }
    }

    @Override
    public void sentToAllClientPlayersTrackingEntity(class_1297 target, Message message) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14178().method_18754(target, this.toVanillaPacket(message));
        }
    }

    @Override
    public void sentToAllClientPlayersTrackingEntityAndSelf(class_1297 target, Message message) {
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_2596<?> p = this.toVanillaPacket(message);
            serverLevel.method_14178().method_18754(target, p);
            if (target instanceof class_3222) {
                class_3222 player = (class_3222)target;
                this.sendToClientPlayer(player, message);
            }
        }
    }

    private class_2596<?> toVanillaPacket(Message message) {
        class_2540 buf = PacketByteBufs.create();
        message.writeToBuffer(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)ID_MAP.get(message.getClass()), (class_2540)buf);
    }

    static class Wrapper
    implements ChannelHandler.Context {
        private final class_1657 player;
        private final NetworkDir dir;

        public Wrapper(class_1657 player, NetworkDir dir) {
            this.player = player;
            this.dir = dir;
        }

        @Override
        public NetworkDir getDirection() {
            return this.dir;
        }

        @Override
        public class_1657 getSender() {
            return this.player;
        }
    }
}

