/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins;

import com.mojang.datafixers.util.Pair;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapData;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.mehvahdjukaar.moonlight.core.misc.IMapDataPacketExtension;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2683;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2683.class})
public class MapItemDataPacketMixin
implements IMapDataPacketExtension {
    @Shadow
    @Final
    @Nullable
    private class_22.class_5637 field_28016;
    @Shadow
    @Final
    private int field_12303;
    @Unique
    private CustomMapDecoration[] moonlight$customDecorations = null;
    @Unique
    private class_2487 moonlight$customData = null;
    @Unique
    private int moonlight$mapCenterX = 0;
    @Unique
    private int moonlight$mapCenterZ = 0;
    @Unique
    private class_2960 moonlight$dimension = class_1937.field_25179.method_29177();
    @Unique
    @Nullable
    private Pair<Boolean, Integer> moonlight$tfData = null;

    @Inject(method={"<init>(IBZLjava/util/Collection;Lnet/minecraft/world/level/saveddata/maps/MapItemSavedData$MapPatch;)V"}, at={@At(value="RETURN")})
    private void addExtraCenterAndDimension(int mapId, byte b, boolean bl, Collection collection, class_22.class_5637 mapPatch, CallbackInfo ci) {
        class_22 data;
        class_3218 level = PlatHelper.getCurrentServer().method_3847(class_1937.field_25179);
        this.moonlight$dimension = null;
        if (level != null && (data = Moonlight.getMapDataFromKnownKeys(level, mapId)) != null) {
            this.moonlight$mapCenterX = data.field_116;
            this.moonlight$mapCenterZ = data.field_115;
            this.moonlight$dimension = data.field_118.method_29177();
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/network/FriendlyByteBuf;)V"}, at={@At(value="RETURN")})
    private void readExtraData(class_2540 buf, CallbackInfo ci) {
        if (buf.readBoolean()) {
            this.moonlight$dimension = buf.method_10810();
            this.moonlight$mapCenterX = buf.method_10816();
            this.moonlight$mapCenterZ = buf.method_10816();
        }
        if (buf.readBoolean()) {
            this.moonlight$customDecorations = new CustomMapDecoration[buf.method_10816()];
            for (int m = 0; m < this.moonlight$customDecorations.length; ++m) {
                MapDecorationType<?, ?> type = MapDataInternal.get(buf.method_10810());
                if (type == null) continue;
                this.moonlight$customDecorations[m] = type.loadDecorationFromBuffer(buf);
            }
        }
        if (buf.readBoolean()) {
            this.moonlight$customData = buf.method_10798();
        }
        if (buf.readBoolean()) {
            boolean first = buf.readBoolean();
            int second = buf.method_10816();
            this.moonlight$tfData = Pair.of((Object)first, (Object)second);
        }
    }

    @Inject(method={"write"}, at={@At(value="RETURN")})
    private void writeExtraData(class_2540 buf, CallbackInfo ci) {
        buf.writeBoolean(this.moonlight$dimension != null);
        if (this.moonlight$dimension != null) {
            buf.method_10812(this.moonlight$dimension);
            buf.method_10804(this.moonlight$mapCenterX);
            buf.method_10804(this.moonlight$mapCenterZ);
        }
        buf.writeBoolean(this.moonlight$customDecorations != null);
        if (this.moonlight$customDecorations != null) {
            buf.method_10804(this.moonlight$customDecorations.length);
            for (CustomMapDecoration decoration : this.moonlight$customDecorations) {
                buf.method_10812(Utils.getID(decoration.getType()));
                decoration.saveToBuffer(buf);
            }
        }
        buf.writeBoolean(this.moonlight$customData != null);
        if (this.moonlight$customData != null) {
            buf.method_10794(this.moonlight$customData);
        }
        buf.writeBoolean(this.moonlight$tfData != null);
        if (this.moonlight$tfData != null) {
            buf.writeBoolean(((Boolean)this.moonlight$tfData.getFirst()).booleanValue());
            buf.method_10804(((Integer)this.moonlight$tfData.getSecond()).intValue());
        }
    }

    @Override
    public void moonlight$sendCustomDecorations(Collection<CustomMapDecoration> decorations) {
        if (PlatHelper.getPhysicalSide().isClient()) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            decorations = decorations.stream().map(e -> {
                e.saveToBuffer(buffer);
                Object d = e.getType().loadDecorationFromBuffer(buffer);
                return d;
            }).toList();
        }
        this.moonlight$customDecorations = (CustomMapDecoration[])decorations.toArray(CustomMapDecoration[]::new);
    }

    @Override
    public void moonlight$sendCustomMapDataTag(class_2487 dataTag) {
        this.moonlight$customData = dataTag;
    }

    @Override
    public class_2487 moonlight$getCustomMapDataTag() {
        return this.moonlight$customData;
    }

    @Override
    public class_22.class_5637 moonlight$getColorPatch() {
        return this.field_28016;
    }

    @Override
    public class_5321<class_1937> moonlight$getDimension() {
        return class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)this.moonlight$dimension);
    }

    @Inject(method={"applyToMap"}, at={@At(value="HEAD")})
    private void handleExtraData(class_22 mapData, CallbackInfo ci) {
        CustomMapDecoration[] serverDeco = this.moonlight$customDecorations;
        class_2487 serverData = this.moonlight$customData;
        mapData.field_116 = this.moonlight$mapCenterX;
        mapData.field_115 = this.moonlight$mapCenterZ;
        mapData.field_118 = this.moonlight$getDimension();
        if ((serverDeco != null || serverData != null) && mapData instanceof ExpandedMapData) {
            ExpandedMapData ed = (ExpandedMapData)mapData;
            if (serverDeco != null) {
                Map<String, CustomMapDecoration> decorations = ed.getCustomDecorations();
                decorations.clear();
                for (int i = 0; i < serverDeco.length; ++i) {
                    CustomMapDecoration customDecoration = serverDeco[i];
                    if (customDecoration != null) {
                        decorations.put("icon-" + i, customDecoration);
                        continue;
                    }
                    Moonlight.LOGGER.warn("Failed to load custom map decoration, skipping");
                }
                for (MapBlockMarker mapBlockMarker : MapDataInternal.getDynamicClient(this.field_12303, mapData)) {
                    Object d = mapBlockMarker.createDecorationFromMarker(mapData);
                    if (d == null) continue;
                    decorations.put(mapBlockMarker.getMarkerId(), (CustomMapDecoration)d);
                }
            }
            if (serverData != null) {
                Map<class_2960, CustomMapData<?>> customData = ed.getCustomData();
                for (CustomMapData<?> v : customData.values()) {
                    v.loadUpdateTag(this.moonlight$customData);
                }
            }
        }
    }

    private static class_2487 readCompressedNbt(class_2540 buf) {
        int i = buf.readerIndex();
        byte b = buf.readByte();
        if (b == 0) {
            throw new EncoderException();
        }
        buf.readerIndex(i);
        try {
            return class_2507.method_10629((InputStream)new ByteBufInputStream((ByteBuf)buf));
        }
        catch (IOException var5) {
            throw new EncoderException((Throwable)var5);
        }
    }

    private static void writeCompressedNbt(class_2540 buf, class_2487 nbt) {
        if (nbt == null) {
            buf.writeByte(0);
        } else {
            try {
                class_2507.method_10634((class_2487)nbt, (OutputStream)new ByteBufOutputStream((ByteBuf)buf));
            }
            catch (IOException var3) {
                throw new EncoderException((Throwable)var3);
            }
        }
    }
}

