/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds;

import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_638;
import net.minecraft.class_746;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientRegion;
import team.creative.ambientsounds.AmbientSound;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.env.AmbientEnvironment;
import team.creative.ambientsounds.sound.AmbientSoundEngine;
import team.creative.creativecore.CreativeCore;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.holder.ConfigHolderDynamic;
import team.creative.creativecore.common.config.holder.CreativeConfigRegistry;
import team.creative.creativecore.common.config.sync.ConfigSynchronization;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.reflection.ReflectionHelper;

public class AmbientTickHandler {
    private static class_310 mc = class_310.method_1551();
    public AmbientSoundEngine soundEngine;
    public AmbientEnvironment environment = null;
    public AmbientEngine engine;
    public int timer = 0;
    public boolean showDebugInfo = false;
    private boolean shouldReload = false;
    public static final DecimalFormat df = new DecimalFormat("0.##");

    public void scheduleReload() {
        this.shouldReload = true;
    }

    public void setEngine(AmbientEngine engine) {
        this.engine = engine;
        this.initConfiguration();
    }

    public void initConfiguration() {
        CreativeConfigRegistry.ROOT.removeField("ambientsounds");
        ConfigHolderDynamic holder = CreativeConfigRegistry.ROOT.registerFolder("ambientsounds", ConfigSynchronization.CLIENT);
        holder.registerValue("general", (Object)AmbientSounds.CONFIG);
        if (this.engine == null) {
            return;
        }
        ConfigHolderDynamic dimensions = holder.registerFolder("dimensions");
        Field dimensionField = ReflectionHelper.findField(AmbientDimension.class, (String)"volumeSetting");
        for (AmbientDimension dimension : this.engine.dimensions.values()) {
            dimensions.registerField(dimension.name, dimensionField, (Object)dimension);
        }
        ConfigHolderDynamic regions = holder.registerFolder("regions");
        Field regionField = ReflectionHelper.findField(AmbientRegion.class, (String)"volumeSetting");
        Field soundField = ReflectionHelper.findField(AmbientSound.class, (String)"volumeSetting");
        for (Map.Entry<String, AmbientRegion> pair : this.engine.allRegions.entrySet()) {
            ConfigHolderDynamic region = regions.registerFolder(pair.getKey().replace(".", "_"));
            region.registerField("overall", regionField, (Object)pair.getValue());
            if (pair.getValue().sounds == null) continue;
            for (AmbientSound sound : pair.getValue().sounds.values()) {
                region.registerField(sound.name, soundField, (Object)sound);
            }
        }
        holder.registerField("fade-volume", ReflectionHelper.findField(AmbientEngine.class, (String)"fadeVolume"), (Object)this.engine);
        holder.registerField("fade-pitch", ReflectionHelper.findField(AmbientEngine.class, (String)"fadePitch"), (Object)this.engine);
        holder.registerField("silent-dimensions", ReflectionHelper.findField(AmbientEngine.class, (String)"silentDimensions"), (Object)this.engine);
        CreativeCore.CONFIG_HANDLER.load("ambientsounds", Side.CLIENT);
    }

    private String format(Object value) {
        if (value instanceof Double || value instanceof Float) {
            return df.format(value);
        }
        return value.toString();
    }

    private String format(List<Pair<String, Object>> details) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Pair<String, Object> pair : details) {
            if (!first) {
                builder.append(",");
            } else {
                first = false;
            }
            if (((String)pair.key).isEmpty()) {
                builder.append(this.format(pair.value));
                continue;
            }
            builder.append(class_124.field_1054 + (String)pair.key + class_124.field_1070 + ":" + this.format(pair.value));
        }
        return builder.toString();
    }

    public void onRender(Object object) {
        if (this.showDebugInfo && this.engine != null && !mc.method_1493() && this.environment != null && AmbientTickHandler.mc.field_1687 != null) {
            ArrayList<String> list = new ArrayList<String>();
            class_332 graphics = (class_332)object;
            ArrayList<Pair<String, Object>> details = new ArrayList<Pair<String, Object>>();
            this.engine.collectDetails(details);
            details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)this.engine.soundEngine.playingCount()));
            details.add((Pair<String, Object>)new Pair((Object)"dim-name", (Object)AmbientTickHandler.mc.field_1687.method_27983().method_29177()));
            list.add(this.format(details));
            details.clear();
            this.environment.collectLevelDetails(details);
            list.add(this.format(details));
            details.clear();
            this.environment.collectPlayerDetails(details, (class_1657)AmbientTickHandler.mc.field_1724);
            list.add(this.format(details));
            details.clear();
            this.environment.collectTerrainDetails(details);
            list.add(this.format(details));
            details.clear();
            this.environment.collectBiomeDetails(details);
            list.add(this.format(details));
            details.clear();
            for (AmbientRegion region : this.engine.activeRegions) {
                details.add((Pair<String, Object>)new Pair((Object)"region", (Object)(class_124.field_1077 + region.name + class_124.field_1070)));
                details.add((Pair<String, Object>)new Pair((Object)"playing", (Object)region.playing.size()));
                list.add(this.format(details));
                details.clear();
                for (AmbientSound sound : region.playing) {
                    if (!sound.isPlaying()) continue;
                    Object text = "";
                    if (sound.stream1 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream1.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream1.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream1.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream1.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream1.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream1.duration));
                        text = "[" + this.format(details) + "]";
                        details.clear();
                    }
                    if (sound.stream2 != null) {
                        details.add((Pair<String, Object>)new Pair((Object)"n", (Object)sound.stream2.location));
                        details.add((Pair<String, Object>)new Pair((Object)"v", (Object)sound.stream2.volume));
                        details.add((Pair<String, Object>)new Pair((Object)"i", (Object)sound.stream2.index));
                        details.add((Pair<String, Object>)new Pair((Object)"p", (Object)sound.stream2.pitch));
                        details.add((Pair<String, Object>)new Pair((Object)"t", (Object)sound.stream2.ticksPlayed));
                        details.add((Pair<String, Object>)new Pair((Object)"d", (Object)sound.stream2.duration));
                        text = (String)text + "[" + this.format(details) + "]";
                        details.clear();
                    }
                    list.add((String)text);
                }
            }
            RenderSystem.defaultBlendFunc();
            class_327 font = AmbientTickHandler.mc.field_1772;
            int top = 2;
            for (String msg : list) {
                if (msg != null && !msg.isEmpty()) {
                    int n = 2 + font.method_1727(msg) + 1;
                    Objects.requireNonNull(font);
                    graphics.method_25294(1, top - 1, n, top + 9 - 1, -1873784752);
                    graphics.method_51433(font, msg, 2, top, 0xE0E0E0, false);
                }
                Objects.requireNonNull(font);
                top += 9;
            }
        }
    }

    public void loadLevel(class_1936 level) {
        if (level.method_8608() && this.engine != null) {
            this.engine.onClientLoad();
        }
    }

    public void onTick() {
        if (this.soundEngine == null) {
            this.soundEngine = new AmbientSoundEngine();
            if (this.engine == null) {
                this.setEngine(AmbientEngine.loadAmbientEngine(this.soundEngine));
            }
            if (this.engine != null) {
                this.engine.soundEngine = this.soundEngine;
            }
        }
        if (this.shouldReload) {
            AmbientSounds.reload();
            this.shouldReload = false;
        }
        if (this.engine == null) {
            return;
        }
        class_638 level = AmbientTickHandler.mc.field_1687;
        class_746 player = AmbientTickHandler.mc.field_1724;
        if (level != null && player != null && AmbientTickHandler.mc.field_1690.method_1630(class_3419.field_15256) > 0.0f) {
            AmbientDimension newDimension;
            if (this.environment == null) {
                this.environment = new AmbientEnvironment();
            }
            if (this.environment.dimension != (newDimension = this.engine.getDimension((class_1937)level))) {
                this.engine.changeDimension(this.environment, newDimension);
                this.environment.dimension = newDimension;
            }
            if (this.timer % this.engine.environmentTickTime == 0) {
                this.environment.analyzeSlow(newDimension, this.engine, (class_1657)player, (class_1937)level, this.timer);
            }
            if (this.timer % this.engine.soundTickTime == 0) {
                this.environment.analyzeFast(newDimension, (class_1657)player, (class_1937)level, mc.method_1534());
                this.environment.dimension.manipulateEnviroment(this.environment);
                this.engine.tick(this.environment);
            }
            this.engine.fastTick(this.environment);
            ++this.timer;
        } else if (!this.engine.activeRegions.isEmpty()) {
            this.engine.stopEngine();
        }
    }
}

