/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.env;

import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_3486;
import net.minecraft.class_4538;
import team.creative.ambientsounds.AmbientDimension;
import team.creative.ambientsounds.AmbientEngine;
import team.creative.ambientsounds.AmbientTickHandler;
import team.creative.ambientsounds.env.BiomeEnvironment;
import team.creative.ambientsounds.env.TerrainEnvironment;
import team.creative.ambientsounds.mod.SereneSeasonsCompat;
import team.creative.creativecore.common.util.type.list.Pair;

public class AmbientEnvironment {
    public AmbientDimension dimension;
    public boolean muted = false;
    public boolean night;
    public double time;
    public double rainSurfaceVolume;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public BiomeEnvironment biome = new BiomeEnvironment();
    public TerrainEnvironment terrain = new TerrainEnvironment();
    public double biomeVolume;
    public HashMap<String, Double> biomeTypeVolumes = new HashMap();
    public double absoluteHeight;
    public double relativeHeight;
    public double relativeMinHeight;
    public double relativeMaxHeight;
    public double underwater;
    public double temperature;

    public boolean isRainAudibleAtSurface() {
        return this.rainSurfaceVolume > 0.0;
    }

    public void analyzeFast(AmbientDimension dimension, class_1657 player, class_1937 level, float deltaTime) {
        this.dimension = dimension;
        this.raining = level.method_8520(player.method_24515());
        this.snowing = ((class_1959)level.method_23753(player.method_24515()).comp_349()).method_8696((class_4538)level, player.method_24515()) && level.method_8419();
        this.thundering = level.method_8546() && !this.snowing;
        this.absoluteHeight = player.method_23320();
        this.relativeHeight = this.absoluteHeight - this.terrain.averageHeight;
        this.relativeMinHeight = this.absoluteHeight - (double)this.terrain.minHeight;
        this.relativeMaxHeight = this.absoluteHeight - (double)this.terrain.maxHeight;
        this.temperature = SereneSeasonsCompat.getTemperature(player);
        this.analyzeUnderwater(player, level);
        this.analyzeTime(level, deltaTime);
    }

    public void analyzeTime(class_1937 level, float deltaTime) {
        double sunAngle = Math.toDegrees(level.method_8442(deltaTime));
        this.night = sunAngle > 90.0 && sunAngle < 270.0;
        double fadeTime = 10.0;
        this.time = sunAngle > 90.0 - fadeTime && sunAngle < 90.0 + fadeTime ? Math.min((sunAngle - (90.0 - fadeTime)) / (fadeTime * 2.0), 1.0) : (sunAngle > 270.0 - fadeTime && sunAngle < 270.0 + fadeTime ? Math.max(1.0 - (sunAngle - (270.0 - fadeTime)) / (fadeTime * 2.0), 0.0) : (this.night ? 0.0 : 1.0));
    }

    public void analyzeUnderwater(class_1657 player, class_1937 level) {
        int depth = 0;
        if (player.method_5777(class_3486.field_15517)) {
            class_2338 blockpos = class_2338.method_49638((class_2374)player.method_33571());
            while (level.method_8316(blockpos).method_15767(class_3486.field_15517)) {
                ++depth;
                blockpos = blockpos.method_10084();
            }
        }
        this.underwater = depth;
    }

    public void analyzeSlow(AmbientDimension dimension, AmbientEngine engine, class_1657 player, class_1937 level, float deltaTime) {
        this.terrain.analyze(engine, dimension, player, level);
        this.biome = new BiomeEnvironment(engine, player, level, this.biomeVolume);
        this.rainSurfaceVolume = this.biome.rainVolume();
    }

    public void collectLevelDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"dimension", (Object)this.dimension));
        details.add((Pair<String, Object>)new Pair((Object)"night", (Object)this.night));
        details.add((Pair<String, Object>)new Pair((Object)"rain", (Object)this.raining));
        details.add((Pair<String, Object>)new Pair((Object)"rainSurfaceVolume", (Object)this.rainSurfaceVolume));
        details.add((Pair<String, Object>)new Pair((Object)"snow", (Object)this.snowing));
        details.add((Pair<String, Object>)new Pair((Object)"storm", (Object)this.thundering));
        details.add((Pair<String, Object>)new Pair((Object)"time", (Object)this.time));
    }

    public void collectPlayerDetails(List<Pair<String, Object>> details, class_1657 player) {
        details.add((Pair<String, Object>)new Pair((Object)"underwater", (Object)this.underwater));
        details.add((Pair<String, Object>)new Pair((Object)"temp", (Object)this.temperature));
        details.add((Pair<String, Object>)new Pair((Object)"height", (Object)("r:" + AmbientTickHandler.df.format(this.relativeHeight) + ",a:" + AmbientTickHandler.df.format(this.terrain.averageHeight) + " (" + AmbientTickHandler.df.format(this.relativeMinHeight) + "," + AmbientTickHandler.df.format(this.relativeMaxHeight) + ")")));
    }

    public void collectTerrainDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"features", (Object)this.terrain.airPocket.features.toString(AmbientTickHandler.df)));
        details.add((Pair<String, Object>)new Pair((Object)"light", (Object)this.terrain.airPocket.averageLight));
        details.add((Pair<String, Object>)new Pair((Object)"sky-light", (Object)this.terrain.airPocket.averageSkyLight));
        details.add((Pair<String, Object>)new Pair((Object)"air", (Object)this.terrain.airPocket.air));
    }

    public void collectBiomeDetails(List<Pair<String, Object>> details) {
        details.add((Pair<String, Object>)new Pair((Object)"b-volume", (Object)this.biomeVolume));
        for (Pair<BiomeEnvironment.BiomeArea, BiomeEnvironment.BiomeStats> pair : this.biome) {
            details.add((Pair<String, Object>)new Pair((Object)((BiomeEnvironment.BiomeArea)pair.getKey()).location.toString(), pair.getValue()));
        }
    }

    public void reload() {
        this.terrain.scanner = null;
    }
}

