/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.batchedentityrendering.impl.ordering;

import de.odysseus.ithaka.digraph.Digraph;
import de.odysseus.ithaka.digraph.Digraphs;
import de.odysseus.ithaka.digraph.MapDigraph;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSet;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetPolicy;
import de.odysseus.ithaka.digraph.util.fas.FeedbackArcSetProvider;
import de.odysseus.ithaka.digraph.util.fas.SimpleFeedbackArcSetProvider;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.coderbot.batchedentityrendering.impl.BlendingStateHolder;
import net.coderbot.batchedentityrendering.impl.TransparencyType;
import net.coderbot.batchedentityrendering.impl.WrappableRenderType;
import net.coderbot.batchedentityrendering.impl.ordering.RenderOrderManager;
import net.minecraft.class_1921;

public class GraphTranslucencyRenderOrderManager
implements RenderOrderManager {
    private final FeedbackArcSetProvider feedbackArcSetProvider = new SimpleFeedbackArcSetProvider();
    private final EnumMap<TransparencyType, Digraph<class_1921>> types = new EnumMap(TransparencyType.class);
    private boolean inGroup = false;
    private final EnumMap<TransparencyType, class_1921> currentTypes = new EnumMap(TransparencyType.class);

    public GraphTranslucencyRenderOrderManager() {
        for (TransparencyType transparencyType : TransparencyType.values()) {
            this.types.put(transparencyType, new MapDigraph());
        }
    }

    private static TransparencyType getTransparencyType(class_1921 class_19212) {
        while (class_19212 instanceof WrappableRenderType) {
            class_19212 = ((WrappableRenderType)class_19212).unwrap();
        }
        if (class_19212 instanceof BlendingStateHolder) {
            return ((BlendingStateHolder)class_19212).getTransparencyType();
        }
        return TransparencyType.GENERAL_TRANSPARENT;
    }

    @Override
    public void begin(class_1921 class_19212) {
        TransparencyType transparencyType = GraphTranslucencyRenderOrderManager.getTransparencyType(class_19212);
        Digraph<class_1921> digraph = this.types.get((Object)transparencyType);
        digraph.add(class_19212);
        if (this.inGroup) {
            class_1921 class_19213 = this.currentTypes.put(transparencyType, class_19212);
            if (class_19213 == null) {
                return;
            }
            int n = digraph.get(class_19213, class_19212).orElse(0);
            digraph.put(class_19213, class_19212, ++n);
        }
    }

    @Override
    public void startGroup() {
        if (this.inGroup) {
            throw new IllegalStateException("Already in a group");
        }
        this.currentTypes.clear();
        this.inGroup = true;
    }

    @Override
    public boolean maybeStartGroup() {
        if (this.inGroup) {
            return false;
        }
        this.currentTypes.clear();
        this.inGroup = true;
        return true;
    }

    @Override
    public void endGroup() {
        if (!this.inGroup) {
            throw new IllegalStateException("Not in a group");
        }
        this.currentTypes.clear();
        this.inGroup = false;
    }

    @Override
    public void reset() {
        this.types.clear();
        for (TransparencyType transparencyType : TransparencyType.values()) {
            this.types.put(transparencyType, new MapDigraph());
        }
    }

    @Override
    public void resetType(TransparencyType transparencyType) {
        this.types.put(transparencyType, new MapDigraph());
    }

    @Override
    public List<class_1921> getRenderOrder() {
        int n = 0;
        for (Digraph<class_1921> object : this.types.values()) {
            n += object.getVertexCount();
        }
        ArrayList arrayList = new ArrayList(n);
        for (Digraph<class_1921> digraph : this.types.values()) {
            FeedbackArcSet<class_1921> feedbackArcSet = this.feedbackArcSetProvider.getFeedbackArcSet(digraph, digraph, FeedbackArcSetPolicy.MIN_WEIGHT);
            if (feedbackArcSet.getEdgeCount() > 0) {
                for (class_1921 class_19212 : feedbackArcSet.vertices()) {
                    for (class_1921 class_19213 : feedbackArcSet.targets(class_19212)) {
                        digraph.remove(class_19212, class_19213);
                    }
                }
            }
            arrayList.addAll(Digraphs.toposort(digraph, false));
        }
        return arrayList;
    }
}

