/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gbuffer_overrides.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.coderbot.iris.gbuffer_overrides.matching.InputAvailability;
import net.coderbot.iris.gbuffer_overrides.matching.RenderCondition;

public class ProgramTable<T> {
    private final List<T> table = new ArrayList<T>();

    public ProgramTable(BiFunction<RenderCondition, InputAvailability, T> biFunction) {
        for (RenderCondition renderCondition : RenderCondition.values()) {
            for (int i = 0; i < 8; ++i) {
                InputAvailability inputAvailability = InputAvailability.unpack(i);
                this.table.add(biFunction.apply(renderCondition, inputAvailability));
            }
        }
    }

    public T match(RenderCondition renderCondition, InputAvailability inputAvailability) {
        int n = renderCondition.ordinal() * 8 + inputAvailability.pack();
        return this.table.get(n);
    }

    public void forEach(Consumer<T> consumer) {
        this.table.forEach(consumer);
    }
}

