/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.Arrays;
import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.Uniform;
import org.lwjgl.BufferUtils;

public class MatrixFromFloatArrayUniform
extends Uniform {
    private final FloatBuffer buffer = BufferUtils.createFloatBuffer((int)16);
    private float[] cachedValue = null;
    private final Supplier<float[]> value;

    MatrixFromFloatArrayUniform(int n, Supplier<float[]> supplier) {
        super(n);
        this.value = supplier;
    }

    @Override
    public void update() {
        float[] fArray = this.value.get();
        if (!Arrays.equals(fArray, this.cachedValue)) {
            this.cachedValue = Arrays.copyOf(fArray, 16);
            this.buffer.put(this.cachedValue);
            this.buffer.rewind();
            RenderSystem.glUniformMatrix4((int)this.location, (boolean)false, (FloatBuffer)this.buffer);
        }
    }
}

