/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.mixin;

import java.lang.management.BufferPoolMXBean;
import java.lang.management.ManagementFactory;
import java.text.StringCharacterIterator;
import java.util.List;
import java.util.Objects;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.option.IrisVideoSettings;
import net.minecraft.class_124;
import net.minecraft.class_340;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_340.class})
public abstract class MixinDebugScreenOverlay {
    @Unique
    private static final List<BufferPoolMXBean> iris$pools = ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class);
    @Unique
    private static final BufferPoolMXBean iris$directPool;

    @Inject(method={"getSystemInformation"}, at={@At(value="RETURN")})
    private void iris$appendShaderPackText(CallbackInfoReturnable<List<String>> callbackInfoReturnable) {
        List list = (List)callbackInfoReturnable.getReturnValue();
        list.add("");
        list.add("[Iris] Version: " + Iris.getFormattedVersion());
        list.add("");
        if (Iris.getIrisConfig().areShadersEnabled()) {
            list.add("[Iris] Shaderpack: " + Iris.getCurrentPackName() + (Iris.isFallback() ? " (fallback)" : ""));
            Iris.getCurrentPack().ifPresent(shaderPack -> list.add("[Iris] " + shaderPack.getProfileInfo()));
            list.add("[Iris] Color space: " + IrisVideoSettings.colorSpace.name());
        } else {
            list.add("[Iris] Shaders are disabled");
        }
        list.add(3, "Direct Buffers: +" + MixinDebugScreenOverlay.iris$humanReadableByteCountBin(iris$directPool.getMemoryUsed()));
        if (!Iris.isSodiumInstalled()) {
            list.add(3, "Native Memory: +" + MixinDebugScreenOverlay.iris$humanReadableByteCountBin(MixinDebugScreenOverlay.iris$getNativeMemoryUsage()));
        }
    }

    @Inject(method={"getGameInformation"}, at={@At(value="RETURN")})
    private void iris$appendShadowDebugText(CallbackInfoReturnable<List<String>> callbackInfoReturnable) {
        List list = (List)callbackInfoReturnable.getReturnValue();
        if (!Iris.isSodiumInstalled() && Iris.getCurrentPack().isPresent()) {
            list.add(1, class_124.field_1054 + "[Iris] Sodium isn't installed; you will have poor performance.");
            list.add(2, class_124.field_1054 + "[Iris] Install Sodium if you want to run benchmarks or get higher FPS!");
        }
        Iris.getPipelineManager().getPipeline().ifPresent(worldRenderingPipeline -> worldRenderingPipeline.addDebugText(list));
    }

    @Unique
    private static String iris$humanReadableByteCountBin(long l) {
        long l2;
        long l3 = l2 = l == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(l);
        if (l2 < 1024L) {
            return l + " B";
        }
        long l4 = l2;
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator("KMGTPE");
        for (int i = 40; i >= 0 && l2 > 0xFFFCCCCCCCCCCCCL >> i; i -= 10) {
            l4 >>= 10;
            stringCharacterIterator.next();
        }
        return String.format("%.3f %ciB", (double)(l4 *= (long)Long.signum(l)) / 1024.0, Character.valueOf(stringCharacterIterator.current()));
    }

    @Unique
    private static long iris$getNativeMemoryUsage() {
        return ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage().getUsed();
    }

    static {
        BufferPoolMXBean bufferPoolMXBean = null;
        for (BufferPoolMXBean bufferPoolMXBean2 : iris$pools) {
            if (!bufferPoolMXBean2.getName().equals("direct")) continue;
            bufferPoolMXBean = bufferPoolMXBean2;
            break;
        }
        iris$directPool = Objects.requireNonNull(bufferPoolMXBean);
    }
}

