/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.pipeline;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.coderbot.iris.Iris;
import net.coderbot.iris.pipeline.transform.PatchShaderType;
import net.fabricmc.loader.api.FabricLoader;

public class ShaderPrinter {
    private static boolean outputLocationCleared = false;
    private static int programCounter = 0;
    private static final Path debugOutDir = FabricLoader.getInstance().getGameDir().resolve("patched_shaders");

    public static void resetPrintState() {
        outputLocationCleared = false;
        programCounter = 0;
    }

    public static ProgramPrintBuilder printProgram(String string) {
        return new ProgramPrintBuilder(string);
    }

    public static class ProgramPrintBuilder {
        private final boolean isActive = Iris.getIrisConfig().areDebugOptionsEnabled();
        private final String prefix = this.isActive ? String.format("%03d_", ++programCounter) : null;
        private final List<String> sources = this.isActive ? new ArrayList(PatchShaderType.values().length * 2) : null;
        private String name;
        private boolean done = false;

        public ProgramPrintBuilder(String string) {
            this.setName(string);
        }

        public ProgramPrintBuilder setName(String string) {
            this.name = string;
            return this;
        }

        private void addItem(String string, String string2) {
            if (string2 != null && this.sources != null) {
                this.sources.add(this.prefix + this.name + string);
                this.sources.add(string2);
            }
        }

        public ProgramPrintBuilder addSource(PatchShaderType patchShaderType, String string) {
            if (this.sources == null) {
                return this;
            }
            this.addItem(patchShaderType.extension, string);
            return this;
        }

        public ProgramPrintBuilder addSources(Map<PatchShaderType, String> map) {
            if (map == null) {
                return this;
            }
            for (Map.Entry<PatchShaderType, String> entry : map.entrySet()) {
                this.addSource(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public ProgramPrintBuilder addJson(String string) {
            if (this.sources == null) {
                return this;
            }
            this.addItem(".json", string);
            return this;
        }

        public void print() {
            if (this.done) {
                return;
            }
            this.done = true;
            if (this.isActive) {
                if (!outputLocationCleared) {
                    try {
                        if (Files.exists(debugOutDir, new LinkOption[0])) {
                            try (Stream<Path> stream = Files.list(debugOutDir);){
                                stream.forEach(path -> {
                                    try {
                                        Files.delete(path);
                                    }
                                    catch (IOException iOException) {
                                        throw new RuntimeException(iOException);
                                    }
                                });
                            }
                        }
                        Files.createDirectories(debugOutDir, new FileAttribute[0]);
                    }
                    catch (IOException iOException) {
                        Iris.logger.warn("Failed to initialize debug patched shader source location", iOException);
                    }
                    outputLocationCleared = true;
                }
                try {
                    for (int i = 0; i < this.sources.size(); i += 2) {
                        Files.write(debugOutDir.resolve(this.sources.get(i)), this.sources.get(i + 1).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                }
                catch (IOException iOException) {
                    Iris.logger.warn("Failed to write debug patched shader source", iOException);
                }
            }
        }
    }
}

