/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shadows;

import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ShadowMatrices {
    private static final float NEAR = 0.05f;
    private static final float FAR = 256.0f;

    public static Matrix4f createOrthoMatrix(float f) {
        return new Matrix4f(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f);
    }

    public static Matrix4f createPerspectiveMatrix(float f) {
        float f2 = (float)(1.0 / Math.tan(Math.toRadians(f) * 0.5));
        return new Matrix4f(f2, 0.0f, 0.0f, 0.0f, 0.0f, f2, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 1.0f);
    }

    public static void createBaselineModelViewMatrix(class_4587 class_45872, float f, float f2) {
        float f3 = f < 0.25f ? f + 0.75f : f - 0.25f;
        class_45872.method_23760().method_23762().identity();
        class_45872.method_23760().method_23761().identity();
        class_45872.method_23760().method_23761().translate(0.0f, 0.0f, -100.0f);
        class_45872.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
        class_45872.method_22907(class_7833.field_40718.rotationDegrees(f3 * -360.0f));
        class_45872.method_22907(class_7833.field_40714.rotationDegrees(f2));
    }

    public static void snapModelViewToGrid(class_4587 class_45872, float f, double d, double d2, double d3) {
        if (Math.abs(f) == 0.0f) {
            return;
        }
        float f2 = (float)d % f;
        float f3 = (float)d2 % f;
        float f4 = (float)d3 % f;
        float f5 = f / 2.0f;
        class_45872.method_23760().method_23761().translate(f2 -= f5, f3 -= f5, f4 -= f5);
    }

    public static void createModelViewMatrix(class_4587 class_45872, float f, float f2, float f3, double d, double d2, double d3) {
        ShadowMatrices.createBaselineModelViewMatrix(class_45872, f, f3);
        ShadowMatrices.snapModelViewToGrid(class_45872, f2, d, d2, d3);
    }

    private static final class Tests {
        private Tests() {
        }

        public static void main(String[] stringArray) {
            Matrix4f matrix4f = new Matrix4f(0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, 0.03125f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f);
            Tests.test("ortho projection hpl=32", matrix4f, ShadowMatrices.createOrthoMatrix(32.0f));
            Matrix4f matrix4f2 = new Matrix4f(0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, 0.009090909f, 0.0f, 0.0f, 0.0f, 0.0f, -0.007814026f, 0.0f, 0.0f, 0.0f, -1.0003906f, 1.0f);
            Tests.test("ortho projection hpl=110", matrix4f2, ShadowMatrices.createOrthoMatrix(110.0f));
            Matrix4f matrix4f3 = new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0003906f, -1.0f, 0.0f, 0.0f, -0.10001954f, 0.0f);
            Tests.test("perspective projection fov=90", matrix4f3, ShadowMatrices.createPerspectiveMatrix(90.0f));
            Matrix4f matrix4f4 = new Matrix4f(0.2154504f, 5.8204815E-8f, 0.9765147f, 0.0f, -0.97651476f, 1.2841845E-8f, 0.21545039f, 0.0f, 0.0f, -0.99999994f, 5.9604645E-8f, 0.0f, 0.3800215f, 1.0264281f, -100.44631f, 1.0f);
            class_4587 class_45872 = new class_4587();
            ShadowMatrices.createModelViewMatrix(class_45872, 0.03451777f, 2.0f, 0.0f, 0.646045982837677, 82.53274536132812, -514.0264282226562);
            Tests.test("model view at dawn", matrix4f4, class_45872.method_23760().method_23761());
        }

        private static void test(String string, Matrix4f matrix4f, Matrix4f matrix4f2) {
            if (matrix4f.equals((Matrix4fc)matrix4f2, 5.0E-4f)) {
                System.err.println("test " + string + " failed: ");
                System.err.println("    expected: ");
                System.err.print(matrix4f.toString());
                System.err.println("    created: ");
                System.err.print(matrix4f2.toString());
            } else {
                System.out.println("test " + string + " passed");
            }
        }
    }
}

