/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network;

import dev.technici4n.moderndynamics.network.Network;
import dev.technici4n.moderndynamics.network.NetworkCache;
import dev.technici4n.moderndynamics.network.NetworkNode;
import dev.technici4n.moderndynamics.network.NodeHost;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public class NetworkManager<H extends NodeHost, C extends NetworkCache<H, C>> {
    private static final Map<Class<?>, NetworkManager<?, ?>> MANAGERS = new IdentityHashMap();
    private final Class<C> cacheClass;
    private final NetworkCache.Factory<H, C> cacheFactory;
    private final IdentityHashMap<class_3218, Long2ObjectOpenHashMap<NetworkNode<H, C>>> nodes = new IdentityHashMap();
    private final Set<NetworkNode<H, C>> pendingUpdates = Collections.newSetFromMap(new IdentityHashMap());
    private final Set<Network<H, C>> networks = Collections.newSetFromMap(new IdentityHashMap());
    private boolean iteratingOverNetworks = false;

    public static synchronized <H extends NodeHost, C extends NetworkCache<H, C>> NetworkManager<H, C> get(Class<C> cacheClass, NetworkCache.Factory<H, C> factory) {
        Objects.requireNonNull(cacheClass, "Cache class may not be null.");
        Objects.requireNonNull(factory, "Factory may not be null.");
        return MANAGERS.computeIfAbsent(cacheClass, c -> new NetworkManager(cacheClass, factory));
    }

    public static synchronized void onServerStopped() {
        for (NetworkManager<?, ?> manager : MANAGERS.values()) {
            manager.nodes.clear();
            manager.pendingUpdates.clear();
            manager.networks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void onEndTick() {
        for (NetworkManager<?, ?> manager : MANAGERS.values()) {
            manager.updateNetworks();
            manager.iteratingOverNetworks = true;
            try {
                for (Network network : manager.networks) {
                    ((NetworkCache)network.cache).tick();
                }
            }
            finally {
                manager.iteratingOverNetworks = false;
            }
        }
    }

    NetworkManager(Class<C> cacheClass, NetworkCache.Factory<H, C> cacheFactory) {
        this.cacheClass = cacheClass;
        this.cacheFactory = cacheFactory;
    }

    public void addNode(class_3218 world, class_2338 pos, H host) {
        if (this.iteratingOverNetworks) {
            throw new ConcurrentModificationException("Node at position " + pos + " in world " + world + " can't be added: networks are being iterated over.");
        }
        Long2ObjectOpenHashMap worldNodes = this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap());
        NetworkNode newNode = new NetworkNode(host);
        if (worldNodes.put(pos.method_10063(), newNode) != null) {
            throw new IllegalArgumentException("Node at position " + pos + " in world " + world + " already exists.");
        }
        this.pendingUpdates.add(newNode);
        for (class_2350 direction : class_2350.values()) {
            class_2338 adjacentPos = pos.method_10093(direction);
            @Nullable NetworkNode adjacentNode = (NetworkNode)worldNodes.get(adjacentPos.method_10063());
            if (adjacentNode == null) continue;
            if (((NodeHost)host).canConnectTo(direction, (NodeHost)adjacentNode.getHost()) && ((NodeHost)adjacentNode.getHost()).canConnectTo(direction.method_10153(), (NodeHost)host)) {
                if (adjacentNode.network != null) {
                    ((NetworkCache)adjacentNode.network.cache).separate();
                }
                newNode.addConnection(direction, adjacentNode);
                adjacentNode.addConnection(direction.method_10153(), newNode);
                adjacentNode.updateHostConnections();
                continue;
            }
            ((NodeHost)newNode.getHost()).onConnectionRejectedTo(direction, (NodeHost)adjacentNode.getHost());
            ((NodeHost)adjacentNode.getHost()).onConnectionRejectedTo(direction.method_10153(), (NodeHost)newNode.getHost());
        }
        newNode.updateHostConnections();
    }

    public void removeNode(class_3218 world, class_2338 pos, H host) {
        if (this.iteratingOverNetworks) {
            throw new ConcurrentModificationException("Node at position " + pos + " in world " + world + " can't be removed: networks are being iterated over.");
        }
        Long2ObjectOpenHashMap worldNodes = this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap());
        NetworkNode node = (NetworkNode)worldNodes.remove(pos.method_10063());
        if (node == null) {
            throw new IllegalArgumentException("Node at position " + pos + " in world " + world + " can't be removed: it doesn't exist.");
        }
        if (node.getHost() != host) {
            throw new IllegalArgumentException("Node at position " + pos + " in world " + world + " can't be removed: the hosts don't match.");
        }
        if (node.network != null) {
            ((NetworkCache)node.network.cache).separate();
            this.networks.remove(node.network);
        }
        this.pendingUpdates.remove(node);
        for (NetworkNode.Connection connection : node.getConnections()) {
            NetworkNode target = connection.target();
            target.removeConnection(connection.direction().method_10153(), node);
            target.updateHostConnections();
            this.pendingUpdates.add(target);
        }
    }

    public void refreshNode(class_3218 world, class_2338 pos, H host) {
        this.removeNode(world, pos, host);
        this.addNode(world, pos, host);
    }

    @Nullable
    public NetworkNode<H, C> findNode(class_3218 world, class_2338 pos) {
        this.updateNetworks();
        return (NetworkNode)this.nodes.computeIfAbsent(world, w -> new Long2ObjectOpenHashMap()).get(pos.method_10063());
    }

    private void updateNetworks() {
        if (this.pendingUpdates.size() == 0) {
            return;
        }
        ArrayList<NetworkNode<H, C>> pendingUpdatesCopy = new ArrayList<NetworkNode<H, C>>(this.pendingUpdates);
        this.pendingUpdates.clear();
        for (NetworkNode networkNode : pendingUpdatesCopy) {
            if (this.pendingUpdates.contains(networkNode)) continue;
            ArrayList nodes = new ArrayList();
            Network network = new Network(nodes);
            this.assignNetworkDfs(networkNode, network);
            network.cache = this.cacheFactory.build((class_3218)((NodeHost)networkNode.getHost()).pipe.method_10997(), network.nodes);
            this.networks.add(network);
        }
        this.pendingUpdates.clear();
    }

    private void assignNetworkDfs(NetworkNode<H, C> u, Network<H, C> network) {
        if (this.pendingUpdates.add(u)) {
            if (u.network != null) {
                this.networks.remove(u.network);
            }
            u.network = network;
            network.nodes.add(u);
            for (NetworkNode.Connection<H, C> connection : u.getConnections()) {
                this.assignNetworkDfs(connection.target(), network);
            }
        }
    }
}

