/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.network.item;

import dev.technici4n.moderndynamics.network.item.FailedInsertStrategy;
import dev.technici4n.moderndynamics.network.item.ItemPath;
import dev.technici4n.moderndynamics.util.SerializationHelper;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public class TravelingItem {
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    public final int id = NEXT_ID.getAndIncrement();
    public final ItemVariant variant;
    public final long amount;
    public final ItemPath path;
    public final FailedInsertStrategy strategy;
    public final double speedMultiplier;
    public double traveledDistance;

    public TravelingItem(ItemVariant variant, long amount, ItemPath path, FailedInsertStrategy strategy, double speedMultiplier, double traveledDistance) {
        if (speedMultiplier < 0.5) {
            speedMultiplier = 0.5;
        }
        this.variant = variant;
        this.amount = amount;
        this.path = path;
        this.strategy = strategy;
        this.speedMultiplier = speedMultiplier;
        this.traveledDistance = traveledDistance;
    }

    public int getPathLength() {
        return this.path.path.length;
    }

    public double getSpeed() {
        return this.speedMultiplier * 0.02;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10566("v", (class_2520)this.variant.toNbt());
        nbt.method_10544("a", this.amount);
        nbt.method_10566("start", (class_2520)SerializationHelper.posToNbt(this.path.startingPos));
        nbt.method_10566("end", (class_2520)SerializationHelper.posToNbt(this.path.targetPos));
        nbt.method_10582("path", SerializationHelper.encodePath(this.path.path));
        nbt.method_10549("speedMultiplier", this.speedMultiplier);
        nbt.method_10582("strategy", this.strategy.getSerializedName());
        nbt.method_10549("d", this.traveledDistance);
        return nbt;
    }

    public static TravelingItem fromNbt(class_2487 nbt) {
        return new TravelingItem(ItemVariant.fromNbt((class_2487)nbt.method_10562("v")), nbt.method_10537("a"), new ItemPath(SerializationHelper.posFromNbt(nbt.method_10562("start")), SerializationHelper.posFromNbt(nbt.method_10562("end")), SerializationHelper.decodePath(nbt.method_10558("path"))), FailedInsertStrategy.bySerializedName(nbt.method_10558("strategy")), nbt.method_10574("speedMultiplier"), nbt.method_10574("d"));
    }
}

