/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.mod.fabric;

import dev.latvian.mods.rhino.mod.util.MojangMappings;
import dev.latvian.mods.rhino.mod.util.RemappingHelper;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.mapping.tree.ClassDef;
import net.fabricmc.mapping.tree.FieldDef;
import net.fabricmc.mapping.tree.MethodDef;
import net.fabricmc.mapping.tree.TinyTree;

public class RhinoModFabric
implements ModInitializer {
    public void onInitialize() {
        if (RemappingHelper.GENERATE) {
            RemappingHelper.run(FabricLoader.getInstance().getModContainer("minecraft").map(ModContainer::getMetadata).map(m -> m.getVersion().getFriendlyString()).orElse(""), RhinoModFabric::generateMappings);
        }
    }

    private static void generateMappings(RemappingHelper.MappingContext context) throws Exception {
        String runtimeNamespace = FabricLauncherBase.getLauncher().getTargetNamespace();
        String rawNamespace = "official";
        TinyTree tinyTree = FabricLauncherBase.getLauncher().getMappingConfiguration().getMappings();
        for (ClassDef classDef : tinyTree.getClasses()) {
            String unmappedClassName = classDef.getName(runtimeNamespace).replace('/', '.');
            String rawClassName = classDef.getName(rawNamespace);
            RemappingHelper.LOGGER.info("- Checking class " + rawClassName);
            MojangMappings.ClassDef mmClass = context.mappings().getClass(rawClassName.replace('/', '.'));
            if (mmClass == null) continue;
            if (!mmClass.mmName.equals(unmappedClassName)) {
                mmClass.unmappedName().setValue((Object)unmappedClassName);
            }
            RemappingHelper.LOGGER.info("Remapped class " + unmappedClassName + " to " + mmClass.displayName);
            for (FieldDef fieldDef : classDef.getFields()) {
                String rawFieldName = fieldDef.getName(rawNamespace);
                MojangMappings.NamedSignature sig = new MojangMappings.NamedSignature(rawFieldName, null);
                MojangMappings.MemberDef mmField = mmClass.members.get(sig);
                if (mmField != null) {
                    String unmappedFieldName = fieldDef.getName(runtimeNamespace);
                    if (unmappedFieldName.equals(mmField.mmName())) continue;
                    mmField.unmappedName().setValue((Object)unmappedFieldName);
                    RemappingHelper.LOGGER.info("Remapped field " + unmappedFieldName + " [" + mmField.rawName() + "] to " + mmField.mmName());
                    continue;
                }
                if (mmClass.ignoredMembers.contains(sig)) continue;
                RemappingHelper.LOGGER.info("Field " + sig + " not found!");
            }
            for (MethodDef methodDef : classDef.getMethods()) {
                String rawMethodName = methodDef.getName(rawNamespace);
                String rawMethodDesc = methodDef.getDescriptor(rawNamespace);
                MojangMappings.NamedSignature sig = new MojangMappings.NamedSignature(rawMethodName, context.mappings().readSignatureFromDescriptor(rawMethodDesc));
                MojangMappings.MemberDef mmMethod = mmClass.members.get(sig);
                if (mmMethod != null) {
                    String unmappedMethodName = methodDef.getName(runtimeNamespace);
                    if (unmappedMethodName.equals(mmMethod.mmName())) continue;
                    mmMethod.unmappedName().setValue((Object)unmappedMethodName);
                    RemappingHelper.LOGGER.info("Remapped method " + unmappedMethodName + rawMethodDesc + " to " + mmMethod.mmName());
                    continue;
                }
                if (mmClass.ignoredMembers.contains(sig)) continue;
                RemappingHelper.LOGGER.info("Method " + sig + " not found!");
            }
        }
    }
}

