/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.spiceoffabric.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import de.siphalor.spiceoffabric.SpiceOfFabric;
import de.siphalor.spiceoffabric.config.SOFConfig;
import de.siphalor.spiceoffabric.foodhistory.FoodHistory;
import de.siphalor.spiceoffabric.networking.SOFCommonNetworking;
import de.siphalor.spiceoffabric.util.IHungerManager;
import de.siphalor.spiceoffabric.util.IServerPlayerEntity;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class}, priority=1100)
public abstract class MixinServerPlayerEntity
extends class_1657
implements IServerPlayerEntity {
    @Unique
    protected boolean foodHistorySync = false;
    @Unique
    protected long lastContainerEatTime;

    @Shadow
    public abstract void method_5702(class_2183.class_2184 var1, class_243 var2);

    protected MixinServerPlayerEntity(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Override
    public void spiceOfFabric_scheduleFoodHistorySync() {
        this.foodHistorySync = true;
    }

    @Override
    public boolean spiceOfFabric_foodHistorySync() {
        boolean result = this.foodHistorySync;
        this.foodHistorySync = false;
        return result;
    }

    @Override
    public long spiceOfFabric_getLastContainerEatTime() {
        return this.lastContainerEatTime;
    }

    @Override
    public void spiceOfFabric_setLastContainerEatTime(long time) {
        this.lastContainerEatTime = time;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void onConstruct(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo ci) {
        ((IHungerManager)this.field_7493).spiceOfFabric_setPlayer((class_3222)this);
        SpiceOfFabric.updateMaxHealth((class_3222)this, false, false);
        this.method_6033(this.method_6063());
    }

    @Inject(method={"copyFrom"}, at={@At(value="RETURN")})
    public void onPlayerCopied(class_3222 reference, boolean exact, CallbackInfo callbackInfo) {
        if (exact) {
            ((IHungerManager)this.field_7493).spiceOfFabric_setPlayer((class_3222)this);
            SpiceOfFabric.updateMaxHealth((class_3222)this, false, false);
            this.method_6033(reference.method_6032());
        } else {
            Pair<Double, Double> respawnHunger = SOFConfig.getRespawnHunger(reference.method_7344().method_7586(), reference.method_7344().method_7589());
            this.field_7493.method_7580((int)Math.max((Double)respawnHunger.getFirst(), (double)reference.method_7344().method_7586()));
            ((IHungerManager)this.field_7493).spiceOfFabric_setSaturationLevel((float)((Double)respawnHunger.getSecond()).doubleValue());
            FoodHistory foodHistory = ((IHungerManager)reference.method_7344()).spiceOfFabric_getFoodHistory();
            if (SOFConfig.respawn.resetHistory) {
                foodHistory.resetHistory();
            }
            if (SOFConfig.carrot.enable && SOFConfig.respawn.resetCarrotMode) {
                foodHistory.resetUniqueFoodsEaten();
            }
            ((IHungerManager)this.field_7493).spiceOfFabric_setFoodHistory(foodHistory);
            SOFCommonNetworking.syncFoodHistory((class_3222)this);
            SpiceOfFabric.updateMaxHealth((class_3222)this, false, false);
            this.method_6033(this.method_6063());
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void afterReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        SpiceOfFabric.updateMaxHealth((class_3222)this, false, false);
        if (nbt.method_10573("Health", 99)) {
            this.method_6033(nbt.method_10583("Health"));
        }
    }
}

