/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4140;
import net.minecraft.class_4149;
import net.minecraft.class_5134;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.object.SquareRadius;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;
import org.jetbrains.annotations.Nullable;

public class NearbyPlayersSensor<E extends class_1309>
extends PredicateSensor<class_1657, E> {
    private static final List<class_4140<?>> MEMORIES = ObjectArrayList.of((Object[])new class_4140[]{class_4140.field_18443, class_4140.field_18444, class_4140.field_22354});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyPlayersSensor() {
        super((player, entity) -> !player.method_7325());
    }

    public NearbyPlayersSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyPlayersSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<class_4140<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public class_4149<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_PLAYERS.get();
    }

    @Override
    protected void method_19101(class_3218 level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.method_26825(class_5134.field_23717);
            radius = new SquareRadius(dist, dist);
        }
        List<class_1657> players = EntityRetrievalUtil.getPlayers((class_1937)level, radius.inflateAABB(entity.method_5829()), player -> this.predicate().test(player, entity));
        players.sort(Comparator.comparingDouble(arg_0 -> entity.method_5858(arg_0)));
        ObjectArrayList targetablePlayers = new ObjectArrayList(players);
        targetablePlayers.removeIf(pl -> !NearbyPlayersSensor.method_30954((class_1309)entity, (class_1309)pl));
        ObjectArrayList attackablePlayers = new ObjectArrayList((Collection)targetablePlayers);
        attackablePlayers.removeIf(pl -> !NearbyPlayersSensor.method_36982((class_1309)entity, (class_1309)pl));
        BrainUtils.setMemory(entity, class_4140.field_18443, players);
        BrainUtils.setMemory(entity, class_4140.field_18444, targetablePlayers.isEmpty() ? null : (class_1657)targetablePlayers.get(0));
        BrainUtils.setMemory(entity, class_4140.field_22354, attackablePlayers.isEmpty() ? null : (class_1657)attackablePlayers.get(0));
    }
}

