/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.rwtema.extrautils2.utils.XURandom;
import java.util.ArrayList;
import java.util.Iterator;

public class ListRandomOffset<E>
implements Iterable<E> {
    final ArrayList<E> list;

    public ListRandomOffset(ArrayList<E> list) {
        this.list = list;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.list.size() <= 1) {
            return this.list.iterator();
        }
        return new Iterator<E>(){
            int cursor = 0;
            int offset;
            {
                this.offset = XURandom.rand.nextInt(ListRandomOffset.this.list.size());
            }

            @Override
            public boolean hasNext() {
                return this.cursor < ListRandomOffset.this.list.size();
            }

            @Override
            public E next() {
                int i = (this.cursor + this.offset) % ListRandomOffset.this.list.size();
                ++this.cursor;
                return ListRandomOffset.this.list.get(i);
            }
        };
    }
}

