/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class WeakPair<L, R> {
    private WeakReference<L> left;
    private WeakReference<R> right;

    public WeakPair(L left, R right) {
        this.left = new WeakReference<L>(left);
        this.right = new WeakReference<R>(right);
    }

    @Nullable
    public L getLeft() {
        WeakReference<R> right;
        WeakReference<L> curLeft = this.left;
        if (curLeft == null) {
            return null;
        }
        Object l = curLeft.get();
        if (l == null || (right = this.right) == null || right.get() == null) {
            this.left = null;
            this.right = null;
            return null;
        }
        return (L)l;
    }

    @Nullable
    public R getRight() {
        WeakReference<L> curLeft;
        WeakReference<R> curRight = this.right;
        if (curRight == null) {
            return null;
        }
        Object r = curRight.get();
        if (r == null || (curLeft = this.left) == null || curLeft.get() == null) {
            this.left = null;
            this.right = null;
            return null;
        }
        return (R)r;
    }

    public Pair<L, R> getPair() {
        WeakReference<L> curLeft = this.left;
        WeakReference<R> curRight = this.right;
        if (curLeft == null || curRight == null) {
            return null;
        }
        Object l = curLeft.get();
        Object r = curRight.get();
        if (l == null || r == null) {
            this.left = null;
            this.right = null;
            return null;
        }
        return Pair.of(l, r);
    }
}

