/*
 * Decompiled with CFR 0.152.
 */
package wanion.lib.client.button;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import wanion.lib.WanionLib;
import wanion.lib.common.IClickAction;
import wanion.lib.common.control.IControlNameable;
import wanion.lib.common.control.IState;
import wanion.lib.common.control.IStateNameable;
import wanion.lib.common.control.IStateProvider;
import wanion.lib.network.ControlSync;

@SideOnly(value=Side.CLIENT)
public abstract class ControlButton<C extends IStateProvider<C, S>, S extends IState<S>>
extends GuiButton
implements IClickAction {
    protected final GuiContainer guiContainer;
    protected final C stateProvider;
    protected final ResourceLocation resourceLocation;
    protected int lineWidth = 0;

    public ControlButton(@Nonnull GuiContainer guiContainer, @Nonnull C stateProvider, @Nonnull ResourceLocation resourceLocation, int buttonId, int x, int y) {
        this(guiContainer, stateProvider, resourceLocation, buttonId, x, y, 18, 18);
    }

    public ControlButton(@Nonnull GuiContainer guiContainer, @Nonnull C stateProvider, @Nonnull ResourceLocation resourceLocation, int buttonId, int x, int y, int widthIn, int heightIn) {
        super(buttonId, x, y, widthIn, heightIn, "");
        this.guiContainer = guiContainer;
        this.stateProvider = stateProvider;
        this.resourceLocation = resourceLocation;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        Object state = this.stateProvider.getState();
        Pair<Integer, Integer> texturePos = state.getTexturePos(this.field_146123_n);
        if (texturePos == null) {
            return;
        }
        mc.func_110434_K().func_110577_a(this.resourceLocation);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        ControlButton.func_146110_a((int)this.field_146128_h, (int)this.field_146129_i, (float)((Integer)texturePos.getLeft()).intValue(), (float)((Integer)texturePos.getRight()).intValue(), (int)this.field_146120_f, (int)this.field_146121_g, (float)128.0f, (float)128.0f);
    }

    public void func_146111_b(int mouseX, int mouseY) {
        String desc;
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        ArrayList<String> description = new ArrayList<String>();
        Object state = this.stateProvider.getState();
        if (this.stateProvider instanceof IControlNameable) {
            description.add(state instanceof IStateNameable ? TextFormatting.RED + I18n.func_135052_a((String)((IControlNameable)this.stateProvider).getControlName(), (Object[])new Object[0]) + ": " + TextFormatting.WHITE + I18n.func_135052_a((String)((IStateNameable)state).getStateName(), (Object[])new Object[0]) : TextFormatting.RED + I18n.func_135052_a((String)((IControlNameable)this.stateProvider).getControlName(), (Object[])new Object[0]));
        }
        if (state instanceof IStateNameable && (desc = ((IStateNameable)state).getStateDescription()) != null) {
            description.add(I18n.func_135052_a((String)desc, (Object[])new Object[0]));
        }
        this.lineWidth = 0;
        for (String line : description) {
            int lineWidth = fontRenderer.func_78256_a(line);
            if (lineWidth <= this.lineWidth) continue;
            this.lineWidth = lineWidth;
        }
        this.guiContainer.func_146283_a(description, this.getTooltipX(this.guiContainer, mouseX), this.getTooltipY(this.guiContainer, mouseY));
    }

    public int getTooltipX(@Nonnull GuiContainer guiContainer, int mouseX) {
        return mouseX - guiContainer.getGuiLeft();
    }

    public int getTooltipY(@Nonnull GuiContainer guiContainer, int mouseY) {
        return mouseY - guiContainer.getGuiTop();
    }

    @Override
    public void action(boolean leftClick) {
        this.func_146113_a(this.guiContainer.field_146297_k.func_147118_V());
        Object state = this.stateProvider.getState();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.stateProvider.writeToNBT(nbtTagCompound, leftClick ? state.getNextState() : state.getPreviousState());
        WanionLib.networkWrapper.sendToServer((IMessage)new ControlSync(this.guiContainer.field_147002_h.field_75152_c, nbtTagCompound));
    }
}

