/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.client.gui.widget.GhostSlot;
import com.enderio.core.common.util.NNList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class GhostBackgroundItemSlot
extends GhostSlot {
    @Nonnull
    private ItemStack stack;
    @Nullable
    private final NNList<ItemStack> stacks;
    private int idx = 999;
    @Nullable
    private final Slot parent;
    private long lastSwitch = 0L;

    private GhostBackgroundItemSlot(@Nonnull ItemStack stack, @Nullable List<ItemStack> stacks, @Nullable Slot parent, int x, int y) {
        this.stack = stack;
        this.stacks = stack.func_190926_b() && stacks != null && !stacks.isEmpty() ? new NNList<ItemStack>((Collection<ItemStack>)stacks) : null;
        this.parent = parent;
        this.setX(x);
        this.setY(y);
        this.setGrayOut(true);
        this.setGrayOutLevel(0.75f);
        this.setDrawStdTooltip(false);
        this.setdrawFakeHover(false);
    }

    public GhostBackgroundItemSlot(@Nonnull ItemStack stack, int x, int y) {
        this(stack, null, null, x, y);
    }

    public GhostBackgroundItemSlot(@Nonnull List<ItemStack> stacks, int x, int y) {
        this(ItemStack.field_190927_a, stacks, null, x, y);
    }

    public GhostBackgroundItemSlot(@Nonnull ItemStack stack, @Nonnull Slot parent) {
        this(stack, null, parent, parent.field_75223_e, parent.field_75221_f);
    }

    public GhostBackgroundItemSlot(@Nonnull List<ItemStack> stacks, @Nonnull Slot parent) {
        this(ItemStack.field_190927_a, stacks, parent, parent.field_75223_e, parent.field_75221_f);
    }

    public GhostBackgroundItemSlot(@Nonnull Item item, int x, int y) {
        this(new ItemStack(item), x, y);
    }

    public GhostBackgroundItemSlot(@Nonnull Block block, int x, int y) {
        this(new ItemStack(block), x, y);
    }

    public GhostBackgroundItemSlot(@Nonnull Item item, @Nonnull Slot parent) {
        this(new ItemStack(item), parent);
    }

    public GhostBackgroundItemSlot(@Nonnull Block block, @Nonnull Slot parent) {
        this(new ItemStack(block), parent);
    }

    @Override
    public boolean isMouseOver(int mx, int my) {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack getStack() {
        NNList<ItemStack> stacks2 = this.stacks;
        if (stacks2 != null && Minecraft.func_71386_F() - this.lastSwitch > 1000L) {
            this.lastSwitch = Minecraft.func_71386_F();
            if (++this.idx >= stacks2.size()) {
                this.idx = 0;
                Collections.shuffle(stacks2);
            }
            this.stack = (ItemStack)stacks2.get(this.idx);
        }
        return this.stack;
    }

    @Override
    public void putStack(@Nonnull ItemStack stackIn, int realsize) {
    }

    @Override
    public boolean isVisible() {
        Slot parent2 = this.parent;
        return parent2 != null ? parent2.field_75223_e >= 0 && parent2.field_75221_f >= 0 && !parent2.func_75216_d() && super.isVisible() : super.isVisible();
    }

    @Override
    public int getX() {
        Slot parent2 = this.parent;
        return parent2 != null ? parent2.field_75223_e : super.getX();
    }

    @Override
    public int getY() {
        Slot parent2 = this.parent;
        return parent2 != null ? parent2.field_75221_f : super.getY();
    }
}

