/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.EnderCore;
import com.google.common.reflect.TypeToken;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.TypeVariable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public abstract class MessageTileEntity<T extends TileEntity>
implements IMessage {
    private long pos;

    protected MessageTileEntity() {
    }

    protected MessageTileEntity(@Nonnull T tile) {
        this.pos = tile.func_174877_v().func_177986_g();
    }

    @Deprecated
    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos);
        this.write(buf);
    }

    public void write(ByteBuf buf) {
    }

    @Deprecated
    public void fromBytes(ByteBuf buf) {
        this.pos = buf.readLong();
        this.read(buf);
    }

    public void read(ByteBuf buf) {
    }

    @Nonnull
    public BlockPos getPos() {
        return BlockPos.func_177969_a((long)this.pos);
    }

    protected T getTileEntity(World worldObj) {
        Class<?> teClass;
        TypeToken teType;
        TypeVariable typeParam0;
        if (worldObj == null || !worldObj.func_175667_e(this.getPos())) {
            return null;
        }
        TileEntity te = worldObj.func_175625_s(this.getPos());
        if (te == null) {
            return null;
        }
        Class<?> ourClass = this.getClass();
        TypeVariable<Class<T>>[] typeParameters = MessageTileEntity.class.getTypeParameters();
        if (typeParameters.length > 0 && (typeParam0 = typeParameters[0]) != null && (teType = TypeToken.of(ourClass).resolveType(typeParam0)).isSupertypeOf(teClass = te.getClass())) {
            return (T)te;
        }
        return null;
    }

    @Nonnull
    protected World getWorld(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        World clientWorld = EnderCore.proxy.getClientWorld();
        if (clientWorld == null) {
            throw new NullPointerException("Recieved network packet ouside any world!");
        }
        return clientWorld;
    }

    public static interface IMessageTileEntityHandler<T extends TileEntity, I extends IMessage>
    extends IMessageHandler<MessageTileEntity<T>, I> {
        @Nullable
        default public I onMessage(MessageTileEntity<T> message, MessageContext ctx) {
            T te;
            if (message != null && ctx != null && (te = message.getTileEntity(message.getWorld(ctx))) != null) {
                return this.onMessage(te, message, ctx);
            }
            return null;
        }

        public I onMessage(@Nonnull T var1, @Nonnull MessageTileEntity<T> var2, @Nonnull MessageContext var3);
    }
}

