/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public final class OreDictionaryHelper {
    public static final String INGOT_COPPER = "ingotCopper";
    public static final String INGOT_TIN = "ingotTin";
    public static final String DUST_ENDERPEARL = "dustEnderPearl";
    public static final String INGOT_ENDERIUM = "ingotEnderium";

    public static boolean isRegistered(String name) {
        return !OreDictionary.getOres((String)name).isEmpty();
    }

    public static boolean hasCopper() {
        return OreDictionaryHelper.isRegistered(INGOT_COPPER);
    }

    public static boolean hasTin() {
        return OreDictionaryHelper.isRegistered(INGOT_TIN);
    }

    public static boolean hasEnderPearlDust() {
        return OreDictionaryHelper.isRegistered(DUST_ENDERPEARL);
    }

    private OreDictionaryHelper() {
    }

    public static boolean hasEnderium() {
        return OreDictionaryHelper.isRegistered(INGOT_ENDERIUM);
    }

    public static String[] getOreNames(@Nonnull ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        String[] ret = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            ret[i] = OreDictionary.getOreName((int)ids[i]);
        }
        return ret;
    }

    public static boolean hasName(@Nonnull ItemStack stack, String oreName) {
        return ArrayUtils.contains((Object[])OreDictionaryHelper.getOreNames(stack), (Object)oreName);
    }
}

