/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.render;

import it.zerono.mods.zerocore.lib.client.render.IVertexSource;
import it.zerono.mods.zerocore.lib.math.Colour;
import it.zerono.mods.zerocore.lib.math.LightMap;
import it.zerono.mods.zerocore.lib.math.UV;
import it.zerono.mods.zerocore.lib.math.Vector3d;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Vertex
implements IVertexSource {
    public final Vector3d POSITION;
    public final Vector3d NORMAL;
    public final UV UV;
    public final Colour COLOUR;
    public final LightMap LIGHT_MAP;

    public Vertex(@Nonnull Vector3d position, @Nonnull Colour colour) {
        this.POSITION = position;
        this.NORMAL = null;
        this.UV = null;
        this.COLOUR = colour;
        this.LIGHT_MAP = null;
    }

    public Vertex(@Nonnull Vector3d position, @Nonnull UV uv) {
        this.POSITION = position;
        this.NORMAL = null;
        this.UV = uv;
        this.COLOUR = null;
        this.LIGHT_MAP = null;
    }

    public Vertex(@Nonnull Vector3d position, @Nullable Vector3d normal, @Nullable UV uv, @Nullable Colour colour, @Nullable LightMap lightMap) {
        this.POSITION = position;
        this.NORMAL = normal;
        this.UV = uv;
        this.COLOUR = colour;
        this.LIGHT_MAP = lightMap;
    }

    @Override
    public void uploadVertexData(@Nonnull BufferBuilder buffer) {
        for (VertexFormatElement element : buffer.func_178973_g().func_177343_g()) {
            switch (element.func_177375_c()) {
                case COLOR: {
                    if (null == this.COLOUR) break;
                    buffer.func_181669_b((int)this.COLOUR.R, (int)this.COLOUR.G, (int)this.COLOUR.B, (int)this.COLOUR.A);
                    break;
                }
                case UV: {
                    if (0 == element.func_177369_e()) {
                        if (null == this.UV) break;
                        buffer.func_187315_a(this.UV.U, this.UV.V);
                        break;
                    }
                    if (null == this.LIGHT_MAP) break;
                    buffer.func_187314_a(this.LIGHT_MAP.SKY_LIGHT, this.LIGHT_MAP.BLOCK_LIGHT);
                    break;
                }
                case NORMAL: {
                    if (null == this.NORMAL) break;
                    buffer.func_181663_c((float)this.NORMAL.X, (float)this.NORMAL.Y, (float)this.NORMAL.Z);
                    break;
                }
                case POSITION: {
                    buffer.func_181662_b(this.POSITION.X, this.POSITION.Y, this.POSITION.Z);
                }
            }
        }
        buffer.func_181675_d();
    }
}

