/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.trap;

import net.darkhax.darkutils.features.trap.TrapType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTrap
extends Block {
    public static final AxisAlignedBB BOUNDS = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
    public static final PropertyEnum<TrapType> VARIANT = PropertyEnum.func_177709_a((String)"variant", TrapType.class);

    public BlockTrap() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(VARIANT, (Comparable)((Object)TrapType.POISON)));
        this.func_149711_c(3.0f);
        this.func_149752_b(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149713_g(0);
    }

    private boolean checkForDrop(World world, BlockPos pos, IBlockState state) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    private boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b()) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    @Deprecated
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDS;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkForDrop(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return ((TrapType)((Object)state.func_177229_b(BlockTrap.VARIANT))).meta;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)TrapType.fromMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((TrapType)((Object)state.func_177229_b(BlockTrap.VARIANT))).meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Deprecated
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    @Deprecated
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Deprecated
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            TrapType type = TrapType.fromMeta(this.func_176201_c(state));
            type.affect.apply(living);
        }
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (TrapType type : TrapType.values()) {
            list.add((Object)new ItemStack((Block)this, 1, type.meta));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

