/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.tileentity.TileParticleGenerator;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.network.PacketParticleGenerator;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class GuiParticleGenerator
extends GuiScreen {
    private static final String I18N_PREFIX = "gui.particleGenerator.";
    private final int xSize = 210;
    private final int ySize = 145;
    private static int page = 1;
    private boolean requiresInit = false;
    private TileParticleGenerator tile;

    public GuiParticleGenerator(TileParticleGenerator tile) {
        this.tile = tile;
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ResourceHelperDE.bindTexture("textures/gui/particle_generator.png");
        int posX = (this.field_146294_l - 210) / 2;
        int posY = (this.field_146295_m - 145) / 2;
        this.func_73729_b(posX, posY, 0, 0, 210, 145);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.particleGenerator.name", (Object[])new Object[0]), this.field_146294_l / 2, posY + 6, 65535);
        this.func_73732_a(this.field_146289_q, page + "/4", this.field_146294_l / 2, posY + 145 - 19, 0xFFFFFF);
        super.func_73863_a(x, y, f);
    }

    public void func_73866_w_() {
        int posX = (this.field_146294_l - 210) / 2;
        int posY = (this.field_146295_m - 145) / 2;
        this.field_146292_n.clear();
        if (page > 1) {
            this.field_146292_n.add(new GuiButtonExt(100, posX + 5, posY + 145 - 25, 20, 20, "<"));
        }
        if (page < 4) {
            this.field_146292_n.add(new GuiButtonExt(101, posX + 210 - 25, posY + 145 - 25, 20, 20, ">"));
        }
        switch (page) {
            default: {
                this.field_146292_n.add(new GuiRangeSliderI(0, posX + 5, posY + 20, I18n.func_135052_a((String)"gui.particleGenerator.red", (Object[])new Object[0]), 0, 255, this.tile.RED.value, this.tile.RANDOM_RED.value));
                this.field_146292_n.add(new GuiRangeSliderI(1, posX + 5, posY + 45, I18n.func_135052_a((String)"gui.particleGenerator.green", (Object[])new Object[0]), 0, 255, this.tile.GREEN.value, this.tile.RANDOM_GREEN.value));
                this.field_146292_n.add(new GuiRangeSliderI(2, posX + 5, posY + 70, I18n.func_135052_a((String)"gui.particleGenerator.blue", (Object[])new Object[0]), 0, 255, this.tile.BLUE.value, this.tile.RANDOM_BLUE.value));
                this.field_146292_n.add(new GuiRangeSliderI(3, posX + 5, posY + 95, I18n.func_135052_a((String)"gui.particleGenerator.alpha", (Object[])new Object[0]), 0, 255, this.tile.ALPHA.value, this.tile.RANDOM_ALPHA.value));
                break;
            }
            case 2: {
                this.field_146292_n.add(new GuiRangeSlider(10, posX + 5, posY + 20, I18n.func_135052_a((String)"gui.particleGenerator.motionX", (Object[])new Object[0]), -2.0, 2.0, this.tile.MOTION_X.value, this.tile.RANDOM_MOTION_X.value).setPrecision(3));
                this.field_146292_n.add(new GuiRangeSlider(11, posX + 5, posY + 45, I18n.func_135052_a((String)"gui.particleGenerator.motionY", (Object[])new Object[0]), -2.0, 2.0, this.tile.MOTION_Y.value, this.tile.RANDOM_MOTION_Y.value).setPrecision(3));
                this.field_146292_n.add(new GuiRangeSlider(12, posX + 5, posY + 70, I18n.func_135052_a((String)"gui.particleGenerator.motionZ", (Object[])new Object[0]), -2.0, 2.0, this.tile.MOTION_Z.value, this.tile.RANDOM_MOTION_Z.value).setPrecision(3));
                this.field_146292_n.add(new GuiRangeSlider(6, posX + 5, posY + 95, I18n.func_135052_a((String)"gui.particleGenerator.gravity", (Object[])new Object[0]), -0.2, 0.2, this.tile.GRAVITY.value, this.tile.RANDOM_GRAVITY.value).setPrecision(3));
                break;
            }
            case 3: {
                this.field_146292_n.add(new GuiRangeSlider(13, posX + 5, posY + 20, I18n.func_135052_a((String)"gui.particleGenerator.spawnX", (Object[])new Object[0]), -10.0, 10.0, this.tile.SPAWN_X.value, this.tile.RANDOM_SPAWN_X.value));
                this.field_146292_n.add(new GuiRangeSlider(14, posX + 5, posY + 45, I18n.func_135052_a((String)"gui.particleGenerator.spawnY", (Object[])new Object[0]), -10.0, 10.0, this.tile.SPAWN_Y.value, this.tile.RANDOM_SPAWN_Y.value));
                this.field_146292_n.add(new GuiRangeSlider(15, posX + 5, posY + 70, I18n.func_135052_a((String)"gui.particleGenerator.spawnZ", (Object[])new Object[0]), -10.0, 10.0, this.tile.SPAWN_Z.value, this.tile.RANDOM_SPAWN_Z.value));
                this.field_146292_n.add(new GuiRangeSlider(4, posX + 5, posY + 95, I18n.func_135052_a((String)"gui.particleGenerator.scale", (Object[])new Object[0]), 0.01, 50.0, this.tile.SCALE.value, this.tile.RANDOM_SCALE.value));
                break;
            }
            case 4: {
                this.field_146292_n.add(new GuiSliderI(16, posX + 5, posY + 20, I18n.func_135052_a((String)"gui.particleGenerator.delay", (Object[])new Object[0]), 1, 200, this.tile.DELAY.value));
                this.field_146292_n.add(new GuiRangeSliderI(5, posX + 5, posY + 45, I18n.func_135052_a((String)"gui.particleGenerator.life", (Object[])new Object[0]), 0, 200, this.tile.LIFE.value, this.tile.RANDOM_LIFE.value));
                this.field_146292_n.add(new GuiRangeSliderI(7, posX + 5, posY + 70, I18n.func_135052_a((String)"gui.particleGenerator.fade", (Object[])new Object[0]), 0, 200, this.tile.FADE.value, this.tile.RANDOM_FADE.value));
                this.field_146292_n.add(new GuiButtonToggle(8, posX + 5, posY + 95, 98, 20, I18n.func_135052_a((String)"gui.particleGenerator.type", (Object[])new Object[0]), this.tile.TYPE.value, I18n.func_135052_a((String)"gui.particleGenerator.type0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.particleGenerator.type1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.particleGenerator.type2", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.particleGenerator.type3", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.particleGenerator.type4", (Object[])new Object[0])));
                this.field_146292_n.add(new GuiButtonToggle(9, posX + 107, posY + 95, 98, 20, I18n.func_135052_a((String)"gui.particleGenerator.collision", (Object[])new Object[0]), this.tile.COLLISION.value ? 1 : 0, I18n.func_135052_a((String)"options.off", (Object[])new Object[0]), I18n.func_135052_a((String)"options.on", (Object[])new Object[0])));
            }
        }
    }

    protected void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 8: {
                DraconicEvolution.network.sendToServer((IMessage)new PacketParticleGenerator(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), (byte)button.field_146127_k, ((GuiButtonToggle)button).getIndex(), 0));
                break;
            }
            case 9: {
                DraconicEvolution.network.sendToServer((IMessage)new PacketParticleGenerator(this.tile.func_174877_v().func_177958_n(), this.tile.func_174877_v().func_177956_o(), this.tile.func_174877_v().func_177952_p(), (byte)button.field_146127_k, ((GuiButtonToggle)button).getIndex(), 0));
                break;
            }
            case 100: {
                --page;
                this.requiresInit = true;
                break;
            }
            case 101: {
                ++page;
                this.requiresInit = true;
            }
        }
    }

    public void func_73869_a(char key, int keyN) throws IOException {
        super.func_73869_a(key, keyN);
        if (key == 'e' || key == '\u001b') {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (mouseButton == 1) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
                if (!(guibutton instanceof GuiRangeSlider) || !((GuiRangeSlider)guibutton).rightClick(this.field_146297_k, mouseX, mouseY)) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.field_146290_a = guibutton = event.getButton();
                guibutton.func_146113_a(this.field_146297_k.func_147118_V());
                this.func_146284_a(guibutton);
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
            }
        }
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (this.field_146290_a instanceof GuiRangeSlider && state == 1) {
            ((GuiRangeSlider)this.field_146290_a).rightReleased(mouseX, mouseY);
            this.field_146290_a = null;
        } else if (this.requiresInit) {
            this.requiresInit = false;
            this.func_73866_w_();
        }
    }

    class GuiButtonToggle
    extends GuiButtonExt {
        String dispString;
        String[] options;
        int index;

        public GuiButtonToggle(int id, int xPos, int yPos, int width, int height, String displayString, int index, String ... options) {
            super(id, xPos, yPos, width, height, displayString + ": " + options[index]);
            this.dispString = displayString + ": ";
            this.index = index;
            this.options = options;
        }

        public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
            if (super.func_146116_c(mc, mouseX, mouseY)) {
                ++this.index;
                if (this.index >= this.options.length) {
                    this.index = 0;
                }
                this.update();
                return true;
            }
            return false;
        }

        public void update() {
            this.field_146126_j = this.dispString + this.getValue();
        }

        public void setIndex(int index) {
            this.index = index;
            this.update();
        }

        public int getIndex() {
            return this.index;
        }

        public String getValue() {
            return this.options[this.index];
        }
    }

    class GuiRangeSliderI
    extends GuiRangeSlider {
        public GuiRangeSliderI(int id, int xPos, int yPos, String displayStr, int minVal, int maxVal, int currentVal, int currentRandom) {
            super(id, xPos, yPos, displayStr, minVal, maxVal, currentVal, currentRandom);
            this.showDecimal = false;
            this.updateSlider();
        }

        @Override
        void sendPacket() {
            DraconicEvolution.network.sendToServer((IMessage)new PacketParticleGenerator(GuiParticleGenerator.this.tile.func_174877_v().func_177958_n(), GuiParticleGenerator.this.tile.func_174877_v().func_177956_o(), GuiParticleGenerator.this.tile.func_174877_v().func_177952_p(), (byte)this.field_146127_k, this.getValueInt(), this.getRandomValueInt()));
        }
    }

    class GuiRangeSlider
    extends GuiSlider {
        public double rangeValue;
        private boolean rightDragging;
        private int dragFrom;
        private double fromValue;

        public GuiRangeSlider(int id, int xPos, int yPos, String displayStr, double minVal, double maxVal, double currentVal, double currentRandom) {
            super(id, xPos, yPos, 200, 20, displayStr + ": ", "", minVal, maxVal, currentVal, true, true, slider -> {});
            this.rangeValue = 1.0;
            this.rightDragging = false;
            this.dragFrom = 0;
            this.fromValue = 0.0;
            this.setRandomValue(currentRandom);
            this.precision = 2;
            this.updateSlider();
        }

        public GuiRangeSlider setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public void updateSlider() {
            String valR;
            String val;
            if (this.sliderValue < 0.0) {
                this.sliderValue = 0.0;
            }
            if (this.sliderValue > 1.0) {
                this.sliderValue = 1.0;
            }
            if (this.rangeValue < 0.0) {
                this.rangeValue = 0.0;
            }
            if (this.rangeValue > 1.0) {
                this.rangeValue = 1.0;
            }
            if (this.rangeValue < this.sliderValue) {
                this.rangeValue = this.sliderValue;
            }
            if (this.showDecimal) {
                val = Double.toString(this.getValue());
                valR = Double.toString(this.getRangeValue());
                if (val.substring(val.indexOf(".") + 1).length() > this.precision) {
                    if ((val = val.substring(0, val.indexOf(".") + this.precision + 1)).endsWith(".")) {
                        val = val.substring(0, val.indexOf(".") + this.precision);
                    }
                } else {
                    while (val.substring(val.indexOf(".") + 1).length() < this.precision) {
                        val = val + "0";
                    }
                }
                if (valR.substring(valR.indexOf(".") + 1).length() > this.precision) {
                    if ((valR = valR.substring(0, valR.indexOf(".") + this.precision + 1)).endsWith(".")) {
                        valR = valR.substring(0, valR.indexOf(".") + this.precision);
                    }
                } else {
                    while (valR.substring(valR.indexOf(".") + 1).length() < this.precision) {
                        valR = valR + "0";
                    }
                }
            } else {
                val = Integer.toString(this.getValueInt());
                valR = Integer.toString(this.getRangeValueInt());
            }
            if (this.drawString) {
                this.field_146126_j = this.dispString + val + " - " + valR + this.suffix;
            }
            if (this.parent != null) {
                this.parent.onChangeSliderValue((GuiSlider)this);
            }
        }

        public boolean func_146116_c(Minecraft par1Minecraft, int mouseX, int par3) {
            if (super.func_146116_c(par1Minecraft, mouseX, par3)) {
                this.dragFrom = mouseX;
                this.fromValue = this.rangeValue;
                this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
                this.dragging = true;
                return true;
            }
            return false;
        }

        public boolean rightClick(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146124_l && this.field_146125_m && mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g) {
                this.dragFrom = mouseX;
                this.fromValue = this.rangeValue;
                this.rangeValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                this.updateSlider();
                this.rightDragging = true;
                return true;
            }
            return false;
        }

        protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
            if (this.field_146125_m) {
                if (this.dragging) {
                    if (GuiScreen.func_146272_n()) {
                        this.sliderValue = this.fromValue + (double)(mouseX - this.dragFrom) / 1000.0;
                    } else {
                        this.sliderValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                        this.dragFrom = mouseX;
                        this.fromValue = this.sliderValue;
                    }
                    this.updateSlider();
                } else if (this.rightDragging) {
                    if (GuiScreen.func_146272_n()) {
                        this.rangeValue = this.fromValue + (double)(mouseX - this.dragFrom) / 1000.0;
                    } else {
                        this.rangeValue = (float)(mouseX - (this.field_146128_h + 4)) / (float)(this.field_146120_f - 8);
                        this.dragFrom = mouseX;
                        this.fromValue = this.rangeValue;
                    }
                    this.updateSlider();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(this.field_146128_h + (int)(this.rangeValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.rangeValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
                this.func_73729_b(this.field_146128_h + (int)(this.sliderValue * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
            }
        }

        public void rightReleased(int mouseX, int mouseY) {
            this.func_146118_a(mouseX, mouseY);
        }

        public void func_146118_a(int par1, int par2) {
            super.func_146118_a(par1, par2);
            this.rightDragging = false;
            this.sendPacket();
        }

        void sendPacket() {
            DraconicEvolution.network.sendToServer((IMessage)new PacketParticleGenerator(GuiParticleGenerator.this.tile.func_174877_v().func_177958_n(), GuiParticleGenerator.this.tile.func_174877_v().func_177956_o(), GuiParticleGenerator.this.tile.func_174877_v().func_177952_p(), (byte)this.field_146127_k, (int)Math.round(this.getValue() * 10000.0), (int)Math.round(this.getRandomValue() * 10000.0)));
        }

        public int getRangeValueInt() {
            return (int)Math.round(this.rangeValue * (this.maxValue - this.minValue) + this.minValue);
        }

        public double getRangeValue() {
            return this.rangeValue * (this.maxValue - this.minValue) + this.minValue;
        }

        public void setRangeValue(double d) {
            this.rangeValue = (d - this.minValue) / (this.maxValue - this.minValue);
        }

        public int getRandomValueInt() {
            return this.getRangeValueInt() - this.getValueInt();
        }

        public double getRandomValue() {
            return this.getRangeValue() - this.getValue();
        }

        public void setRandomValue(double d) {
            this.setRangeValue(this.getValue() + d);
        }
    }

    class GuiSliderI
    extends GuiSlider {
        public GuiSliderI(int id, int xPos, int yPos, String displayStr, int minVal, int maxVal, int currentVal) {
            super(id, xPos, yPos, 200, 20, displayStr + ": ", "", (double)minVal, (double)maxVal, (double)currentVal, false, true, slider -> {});
        }

        public void func_146118_a(int par1, int par2) {
            super.func_146118_a(par1, par2);
            DraconicEvolution.network.sendToServer((IMessage)new PacketParticleGenerator(GuiParticleGenerator.this.tile.func_174877_v().func_177958_n(), GuiParticleGenerator.this.tile.func_174877_v().func_177956_o(), GuiParticleGenerator.this.tile.func_174877_v().func_177952_p(), (byte)this.field_146127_k, this.getValueInt(), 0));
        }
    }
}

