/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.network.PacketCompressible;
import com.brandon3055.draconicevolution.utils.LogHelper;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CrystalUpdateBatcher
extends PacketCompressible {
    public static final Map<Integer, BlockPos> ID_CRYSTAL_MAP = new HashMap<Integer, BlockPos>();
    private static final Map<EntityPlayerMP, List<BatchedCrystalUpdate>> batchQue = new HashMap<EntityPlayerMP, List<BatchedCrystalUpdate>>();
    private List<BatchedCrystalUpdate> packetData;

    public static void queData(BatchedCrystalUpdate update, EntityPlayerMP target) {
        if (!batchQue.containsKey(target)) {
            batchQue.put(target, new ArrayList());
        }
        batchQue.get(target).add(update);
    }

    public static void tickEnd() {
        if (!batchQue.isEmpty()) {
            for (EntityPlayerMP playerMP : batchQue.keySet()) {
                CrystalUpdateBatcher packet = new CrystalUpdateBatcher();
                packet.packetData = batchQue.get(playerMP);
                DraconicEvolution.network.sendTo((IMessage)packet, playerMP);
            }
            batchQue.clear();
        }
    }

    @Override
    public void writeBytes(ByteBuf buf) {
        if (this.packetData.size() > Short.MAX_VALUE) {
            LogHelper.error("Do you seriously have more that 32000 crystals in your base? W... T... F...");
            buf.writeShort(0);
            return;
        }
        buf.writeShort(this.packetData.size());
        for (BatchedCrystalUpdate update : this.packetData) {
            update.writeData(buf);
        }
    }

    @Override
    public void readBytes(ByteBuf buf) {
        this.packetData = new ArrayList<BatchedCrystalUpdate>();
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            BatchedCrystalUpdate update = new BatchedCrystalUpdate();
            update.readData(buf);
            this.packetData.add(update);
        }
    }

    public static class BatchedCrystalUpdate {
        public int crystalID;
        public int crystalCapacity;
        public Map<Byte, Byte> indexToFlowMap = new LinkedHashMap<Byte, Byte>();

        public BatchedCrystalUpdate() {
        }

        public BatchedCrystalUpdate(int crystalID, int crystalCapacity) {
            this.crystalID = crystalID;
            this.crystalCapacity = crystalCapacity;
        }

        public void writeData(ByteBuf buf) {
            buf.writeInt(this.crystalID);
            buf.writeInt(this.crystalCapacity);
            buf.writeByte(this.indexToFlowMap.size());
            for (Byte index : this.indexToFlowMap.keySet()) {
                buf.writeByte((int)index.byteValue());
                buf.writeByte((int)this.indexToFlowMap.get(index).byteValue());
            }
        }

        public void readData(ByteBuf buf) {
            this.crystalID = buf.readInt();
            this.crystalCapacity = buf.readInt();
            int count = buf.readByte();
            for (int i = 0; i < count; ++i) {
                byte index = buf.readByte();
                this.indexToFlowMap.put(index, buf.readByte());
            }
        }
    }

    public static class Handler
    extends MessageHandlerWrapper<CrystalUpdateBatcher, IMessage> {
        public IMessage handleMessage(CrystalUpdateBatcher message, MessageContext ctx) {
            for (BatchedCrystalUpdate update : message.packetData) {
                TileEntity tile;
                if (!ID_CRYSTAL_MAP.containsKey(update.crystalID) || !((tile = BrandonsCore.proxy.getClientWorld().func_175625_s(ID_CRYSTAL_MAP.get(update.crystalID))) instanceof TileCrystalBase) || tile.func_145837_r()) continue;
                ((TileCrystalBase)tile).receiveBatchedUpdate(update);
            }
            return null;
        }
    }
}

